/*
 * Decompiled with CFR 0.152.
 */
package nl.pvanassen.geckoboard.api.widget;

import com.google.gson.annotations.SerializedName;
import nl.pvanassen.geckoboard.api.Push;
import nl.pvanassen.geckoboard.api.error.ValidationException;
import nl.pvanassen.geckoboard.api.json.map.AbstractPoint;
import nl.pvanassen.geckoboard.api.json.map.CityPoint;
import nl.pvanassen.geckoboard.api.json.map.HostPoint;
import nl.pvanassen.geckoboard.api.json.map.IpPoint;
import nl.pvanassen.geckoboard.api.json.map.LatLonPoint;
import nl.pvanassen.geckoboard.api.json.map.Points;

public class Map
extends Push {
    @SerializedName(value="points")
    private final Points points = new Points();

    public Map(String widgetKey) {
        super(widgetKey);
    }

    public CityPoint addCityPoint(String cityName, String regionCode, String countryCode) {
        CityPoint cityPoint = new CityPoint(cityName, regionCode, countryCode);
        this.points.addPoint(cityPoint);
        return cityPoint;
    }

    public CityPoint addCityPoint(String cityName, String regionCode) {
        CityPoint cityPoint = new CityPoint(cityName, regionCode, null);
        this.points.addPoint(cityPoint);
        return cityPoint;
    }

    public CityPoint addCityPoint(String cityName) {
        CityPoint cityPoint = new CityPoint(cityName, null, null);
        this.points.addPoint(cityPoint);
        return cityPoint;
    }

    public HostPoint addHostPoint(String hostname) {
        HostPoint hostPoint = new HostPoint(hostname);
        this.points.addPoint(hostPoint);
        return hostPoint;
    }

    public IpPoint addIpPoint(String ip) {
        IpPoint ipPoint = new IpPoint(ip);
        this.points.addPoint(ipPoint);
        return ipPoint;
    }

    public LatLonPoint addLatLonPoint(String latitude, String longitute) {
        LatLonPoint latLonPoint = new LatLonPoint(latitude, longitute);
        this.points.addPoint(latLonPoint);
        return latLonPoint;
    }

    public <T extends AbstractPoint> T addPoint(T point) {
        this.points.addPoint(point);
        return point;
    }

    @Override
    protected void validate() throws ValidationException {
    }
}

