/*
 * Decompiled with CFR 0.152.
 */
package nl.pvanassen.guicejunitrunner;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;

public class GuiceJUnitRunner
extends BlockJUnit4ClassRunner {
    private Injector injector;

    public GuiceJUnitRunner(Class<?> klass) throws InitializationError {
        super(klass);
        Class<?>[] classes = this.getModulesFor(klass);
        this.injector = this.createInjectorFor(classes);
    }

    public Object createTest() throws Exception {
        Object obj = super.createTest();
        this.injector.injectMembers(obj);
        return obj;
    }

    private Injector createInjectorFor(Class<?>[] classes) throws InitializationError {
        Module[] modules = new Module[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            try {
                modules[i] = (Module)classes[i].newInstance();
                continue;
            }
            catch (InstantiationException e) {
                throw new InitializationError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new InitializationError((Throwable)e);
            }
        }
        return Guice.createInjector((Module[])modules);
    }

    private Class<?>[] getModulesFor(Class<?> klass) throws InitializationError {
        GuiceModules annotation = klass.getAnnotation(GuiceModules.class);
        if (annotation == null) {
            throw new InitializationError("Missing @GuiceModules annotation for unit test '" + klass.getName() + "'");
        }
        return annotation.value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface GuiceModules {
        public Class<?>[] value();
    }
}

