/*
 * Decompiled with CFR 0.152.
 */
package nl.pvanassen.guicejunitrunner;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import nl.pvanassen.guicejunitrunner.GuiceModules;
import org.junit.runners.model.InitializationError;

class GuiceHelper {
    GuiceHelper() {
    }

    static Injector createInjectorFor(Class<?>[] classes, Module extraModule) throws InitializationError {
        Module[] modules = extraModule != null ? new Module[classes.length + 1] : new Module[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            try {
                modules[i] = (Module)classes[i].newInstance();
                continue;
            }
            catch (InstantiationException e) {
                throw new InitializationError((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new InitializationError((Throwable)e);
            }
        }
        if (extraModule != null) {
            modules[classes.length] = extraModule;
        }
        return Guice.createInjector((Module[])modules);
    }

    static Class<?>[] getModulesFor(Class<?> klass) throws InitializationError {
        GuiceModules annotation = klass.getAnnotation(GuiceModules.class);
        if (annotation == null) {
            throw new InitializationError("Missing @GuiceModules annotation for unit test '" + klass.getName() + "'");
        }
        return annotation.value();
    }
}

