/*
 * Decompiled with CFR 0.152.
 */
package nl.pvanassen.guicejunitrunner;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.matcher.Matchers;
import javax.inject.Inject;
import nl.pvanassen.guicejunitrunner.GuiceHelper;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.ibatis.session.SqlSessionManager;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.mybatis.guice.transactional.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceMyBatisRollbackJUnitRunner
extends BlockJUnit4ClassRunner {
    private final Logger logger = LoggerFactory.getLogger(GuiceMyBatisRollbackJUnitRunner.class);
    private final Injector injector;
    @Inject
    private SqlSessionManager sqlSessionManager;

    public GuiceMyBatisRollbackJUnitRunner(Class<?> klass) throws InitializationError {
        super(klass);
        Class<?>[] classes = GuiceHelper.getModulesFor(klass);
        this.injector = GuiceHelper.createInjectorFor(classes, (Module)new AbstractModule(){

            protected void configure() {
                this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Transactional.class), new MethodInterceptor[]{new MethodInterceptor(){

                    public Object invoke(MethodInvocation invocation) throws Throwable {
                        if (GuiceMyBatisRollbackJUnitRunner.this.sqlSessionManager != null && GuiceMyBatisRollbackJUnitRunner.this.sqlSessionManager.isManagedSessionStarted()) {
                            GuiceMyBatisRollbackJUnitRunner.this.sqlSessionManager.clearCache();
                        }
                        return invocation.proceed();
                    }
                }});
            }
        });
    }

    protected Statement methodInvoker(final FrameworkMethod method, final Object test) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    GuiceMyBatisRollbackJUnitRunner.this.sqlSessionManager.startManagedSession();
                    GuiceMyBatisRollbackJUnitRunner.this.logger.debug("running method: " + method.getMethod().getName());
                    method.invokeExplosively(test, new Object[0]);
                }
                finally {
                    try {
                        GuiceMyBatisRollbackJUnitRunner.this.sqlSessionManager.rollback(true);
                    }
                    finally {
                        GuiceMyBatisRollbackJUnitRunner.this.sqlSessionManager.close();
                    }
                }
            }
        };
    }

    public Object createTest() throws Exception {
        Object obj = super.createTest();
        this.injector.injectMembers(obj);
        this.injector.injectMembers((Object)this);
        return obj;
    }
}

