/*
 * Decompiled with CFR 0.152.
 */
package nl.pvanassen.led.animation.common.canvas;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0002\"#B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0006J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0006J(\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00032\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0006J\u001e\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lnl/pvanassen/led/animation/common/canvas/Canvas;", "", "mask", "Ljava/awt/image/BufferedImage;", "pixels", "", "", "(Ljava/awt/image/BufferedImage;Ljava/util/List;)V", "canvas", "positions", "Lnl/pvanassen/led/animation/common/canvas/Canvas$Positions;", "totalPixels", "drawImage", "", "img", "Ljava/awt/Image;", "getHeight", "getValues", "", "getWidth", "setImage", "offsetX", "offsetY", "image", "outOfBoundsBlack", "", "setRGB", "x", "y", "rgb", "setValue", "strip", "pixel", "color", "Position", "Positions", "animation-common"})
public final class Canvas {
    @NotNull
    private final BufferedImage mask;
    @NotNull
    private final List<Integer> pixels;
    @NotNull
    private final BufferedImage canvas;
    private final int totalPixels;
    @NotNull
    private final Positions positions;

    /*
     * WARNING - void declaration
     */
    public Canvas(@NotNull BufferedImage mask, @NotNull List<Integer> pixels) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Triple it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)mask, (String)"mask");
        Intrinsics.checkNotNullParameter(pixels, (String)"pixels");
        this.mask = mask;
        this.pixels = pixels;
        this.canvas = new BufferedImage(this.mask.getWidth(), this.mask.getHeight(), 1);
        this.totalPixels = CollectionsKt.sumOfInt((Iterable)this.pixels);
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)this.mask.getWidth());
        boolean $i$f$flatMap = false;
        void var6_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            int element$iv$iv;
            int x = element$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            Iterable iterable2 = (Iterable)RangesKt.until((int)0, (int)this.mask.getHeight());
            boolean $i$f$map = false;
            void var15_17 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                void y;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new Triple((Object)x, (Object)((int)y), (Object)(this.mask.getRGB(x, (int)y) & 0xFFFFFF)));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Triple)element$iv$iv;
            boolean bl = false;
            if (!(((Number)it.getThird()).intValue() != 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Triple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Position(((Number)it.getThird()).intValue() >> 16 & 0xFF, ((Number)it.getThird()).intValue() & 0xFF, ((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue()));
        }
        List positionsList = (List)destination$iv$iv;
        this.positions = new Positions(positionsList, this.pixels);
    }

    @NotNull
    public final byte[] getValues() {
        int base = 0;
        byte[] values = new byte[this.totalPixels * 3];
        int n = this.pixels.size();
        for (int strip = 0; strip < n; ++strip) {
            int n2 = ((Number)this.pixels.get(strip)).intValue();
            for (int pixel = 0; pixel < n2; ++pixel) {
                int x = this.positions.getX(strip, pixel);
                int y = this.positions.getY(strip, pixel);
                int color = this.canvas.getRGB(x, y);
                byte red = (byte)(color >> 16 & 0xFF);
                byte green = (byte)(color >> 8 & 0xFF);
                byte blue = (byte)(color & 0xFF);
                values[base] = red;
                values[base + 1] = green;
                values[base + 2] = blue;
                base += 3;
            }
        }
        return values;
    }

    public final void setValue(int strip, int pixel, int color) {
        int x = this.positions.getX(strip, pixel);
        int y = this.positions.getY(strip, pixel);
        this.canvas.setRGB(x, y, color);
    }

    public final void setRGB(int x, int y, int rgb) {
        this.canvas.setRGB(x, y, rgb);
    }

    public final void setImage(int offsetX, int offsetY, @NotNull BufferedImage image, boolean outOfBoundsBlack) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        int n = this.pixels.size();
        for (int strip = 0; strip < n; ++strip) {
            int n2 = ((Number)this.pixels.get(strip)).intValue();
            for (int pixel = 0; pixel < n2; ++pixel) {
                int x = this.positions.getX(strip, pixel) + offsetX;
                int y = this.positions.getY(strip, pixel) + offsetY;
                int color = (x >= image.getWidth() || y >= image.getHeight()) && outOfBoundsBlack ? 0 : image.getRGB(Math.max(0, x), Math.max(0, y));
                this.canvas.setRGB(this.positions.getX(strip, pixel), this.positions.getY(strip, pixel), color);
            }
        }
    }

    public static /* synthetic */ void setImage$default(Canvas canvas, int n, int n2, BufferedImage bufferedImage, boolean bl, int n3, Object object) {
        if ((n3 & 8) != 0) {
            bl = true;
        }
        canvas.setImage(n, n2, bufferedImage, bl);
    }

    public final void drawImage(@NotNull Image img) {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        this.canvas.getGraphics().drawImage(img, 0, 0, null);
    }

    public final int getWidth() {
        return this.canvas.getWidth();
    }

    public final int getHeight() {
        return this.canvas.getHeight();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006J\u0016\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0011"}, d2={"Lnl/pvanassen/led/animation/common/canvas/Canvas$Positions;", "", "positions", "", "Lnl/pvanassen/led/animation/common/canvas/Canvas$Position;", "pixelStrips", "", "(Ljava/util/List;Ljava/util/List;)V", "raster", "", "[[Lnl/pvanassen/led/animation/common/canvas/Canvas$Position;", "getX", "strip", "pixel", "getY", "toString", "", "animation-common"})
    private static final class Positions {
        @NotNull
        private final List<Position> positions;
        @NotNull
        private final Position[][] raster;

        /*
         * WARNING - void declaration
         */
        public Positions(@NotNull List<Position> positions, @NotNull List<Integer> pixelStrips) {
            Iterable $this$filter$iv;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter(positions, (String)"positions");
            Intrinsics.checkNotNullParameter(pixelStrips, (String)"pixelStrips");
            this.positions = positions;
            Iterable iterable = (Iterable)new IntRange(0, pixelStrips.size());
            Positions positions2 = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void $this$filterTo$iv$iv;
                void strip;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                collection = destination$iv$iv;
                boolean bl = false;
                Iterable iterable2 = this.positions;
                Integer n2 = (int)strip;
                boolean $i$f$filter = false;
                Iterator iterator2 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Position it = (Position)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it.getStrip() == strip)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv2;
                Integer n3 = n2;
                collection.add(new Pair((Object)n3, (Object)list));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$toTypedArray$iv;
                Collection $this$sortedBy$iv;
                void $this$filterTo$iv$iv;
                void stripPositions;
                Pair strip = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                $this$filter$iv = (Iterable)stripPositions.getSecond();
                boolean $i$f$filter = false;
                Iterable iterable3 = $this$filter$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Position it = (Position)element$iv$iv;
                    boolean bl3 = false;
                    int n = ((Number)pixelStrips.get(((Number)stripPositions.getFirst()).intValue())).intValue();
                    int n4 = it.getPixel();
                    boolean bl4 = 0 <= n4 ? n4 <= n : false;
                    if (!bl4) continue;
                    destination$iv$iv3.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv3;
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Position it = (Position)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getPixel());
                        it = (Position)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPixel()));
                    }
                });
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                Position[] positionArray = thisCollection$iv.toArray(new Position[0]);
                Intrinsics.checkNotNull((Object)positionArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                collection.add(positionArray);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            T[] TArray = thisCollection$iv.toArray((T[])new Position[0][]);
            Intrinsics.checkNotNull(TArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            positions2.raster = (Position[][])TArray;
        }

        public final int getX(int strip, int pixel) {
            return this.raster[strip][pixel].getX();
        }

        public final int getY(int strip, int pixel) {
            return this.raster[strip][pixel].getY();
        }

        @NotNull
        public String toString() {
            return ((Object[])this.raster).toString();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lnl/pvanassen/led/animation/common/canvas/Canvas$Position;", "", "strip", "", "pixel", "x", "y", "(IIII)V", "getPixel", "()I", "getStrip", "getX", "getY", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "animation-common"})
    private static final class Position {
        private final int strip;
        private final int pixel;
        private final int x;
        private final int y;

        public Position(int strip, int pixel, int x, int y) {
            this.strip = strip;
            this.pixel = pixel;
            this.x = x;
            this.y = y;
        }

        public final int getStrip() {
            return this.strip;
        }

        public final int getPixel() {
            return this.pixel;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final int component1() {
            return this.strip;
        }

        public final int component2() {
            return this.pixel;
        }

        public final int component3() {
            return this.x;
        }

        public final int component4() {
            return this.y;
        }

        @NotNull
        public final Position copy(int strip, int pixel, int x, int y) {
            return new Position(strip, pixel, x, y);
        }

        public static /* synthetic */ Position copy$default(Position position, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = position.strip;
            }
            if ((n5 & 2) != 0) {
                n2 = position.pixel;
            }
            if ((n5 & 4) != 0) {
                n3 = position.x;
            }
            if ((n5 & 8) != 0) {
                n4 = position.y;
            }
            return position.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "Position(strip=" + this.strip + ", pixel=" + this.pixel + ", x=" + this.x + ", y=" + this.y + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.strip);
            result = result * 31 + Integer.hashCode(this.pixel);
            result = result * 31 + Integer.hashCode(this.x);
            result = result * 31 + Integer.hashCode(this.y);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Position)) {
                return false;
            }
            Position position = (Position)other;
            if (this.strip != position.strip) {
                return false;
            }
            if (this.pixel != position.pixel) {
                return false;
            }
            if (this.x != position.x) {
                return false;
            }
            return this.y == position.y;
        }
    }
}

