/*
 * Decompiled with CFR 0.152.
 */
package nl.pvanassen.led.animation.common;

import io.ktor.server.config.ApplicationConfig;
import io.ktor.server.config.yaml.YamlConfig;
import io.ktor.server.config.yaml.YamlConfigJvmKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nl.pvanassen.led.animation.common.ControllerClient;
import nl.pvanassen.led.animation.common.model.AnimationFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0002\b\u0003 \u0007*\b\u0012\u0002\b\u0003\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnl/pvanassen/led/animation/common/Context;", "", "()V", "animationFactory", "Lnl/pvanassen/led/animation/common/model/AnimationFactory;", "animationFactoryClass", "Ljava/lang/Class;", "kotlin.jvm.PlatformType", "config", "Lio/ktor/server/config/yaml/YamlConfig;", "getConfig", "()Lio/ktor/server/config/yaml/YamlConfig;", "controllerClient", "Lnl/pvanassen/led/animation/common/ControllerClient;", "getControllerClient", "()Lnl/pvanassen/led/animation/common/ControllerClient;", "controllerHost", "", "controllerPort", "", "animation-common"})
public final class Context {
    @NotNull
    public static final Context INSTANCE = new Context();
    @NotNull
    private static final YamlConfig config;
    @NotNull
    private static final String controllerHost;
    private static final int controllerPort;
    private static final Class<?> animationFactoryClass;
    @NotNull
    private static final AnimationFactory<?> animationFactory;
    @NotNull
    private static final ControllerClient controllerClient;

    private Context() {
    }

    @NotNull
    public final YamlConfig getConfig() {
        return config;
    }

    @NotNull
    public final ControllerClient getControllerClient() {
        return controllerClient;
    }

    static {
        YamlConfig yamlConfig = YamlConfigJvmKt.YamlConfig(null);
        Intrinsics.checkNotNull((Object)yamlConfig);
        config = yamlConfig;
        controllerHost = config.property("app.controller.host").getString();
        controllerPort = Integer.parseInt(config.property("app.controller.port").getString());
        animationFactoryClass = Class.forName(config.property("app.animation-factory").getString());
        Object obj = animationFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type nl.pvanassen.led.animation.common.model.AnimationFactory<*>");
        animationFactory = (AnimationFactory)obj;
        controllerClient = new ControllerClient(controllerHost, controllerPort, animationFactory, (ApplicationConfig)config);
    }
}

