/*
 * Decompiled with CFR 0.152.
 */
package nl.pvanassen.led.animation.common.util;

import java.awt.Color;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u001e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0011J\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004\u00a8\u0006\u0016"}, d2={"Lnl/pvanassen/led/animation/common/util/ColorUtils;", "", "()V", "fadeColor", "", "c", "brightness", "getBlue", "color", "getGreen", "getRed", "makeColor", "red", "green", "blue", "makeColorHSB", "hue", "", "saturation", "mixColor", "c1", "c2", "animation-common"})
public final class ColorUtils {
    @NotNull
    public static final ColorUtils INSTANCE = new ColorUtils();

    private ColorUtils() {
    }

    public final int makeColor(int red, int green, int blue) {
        int r = red & 0xFF;
        int g = green & 0xFF;
        int b = blue & 0xFF;
        return r << 16 | g << 8 | b;
    }

    public final int makeColorHSB(float hue, float saturation, float brightness) {
        return Color.HSBtoRGB(hue, saturation, brightness);
    }

    public final int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    public final int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public final int getBlue(int color) {
        return color & 0xFF;
    }

    public final int fadeColor(int c, int brightness) {
        int r = c >> 16 & 0xFF;
        int g = c >> 8 & 0xFF;
        int b = c & 0xFF;
        float newbr = (float)brightness / 255.0f;
        r = (int)((float)r * newbr);
        g = (int)((float)g * newbr);
        b = (int)((float)b * newbr);
        return r << 16 | g << 8 | b;
    }

    public final int mixColor(int c1, int c2) {
        float red = (float)(this.getRed(c1) + this.getRed(c2)) / 2.0f;
        float green = (float)(this.getGreen(c1) + this.getGreen(c2)) / 2.0f;
        float blue = (float)(this.getBlue(c1) + this.getBlue(c2)) / 2.0f;
        return this.makeColor((int)red, (int)green, (int)blue);
    }
}

