/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.execution;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Set;

public class WoolVariableStore
extends Observable {
    private Map<String, Object> variableMap = new HashMap<String, Object>();

    public void setValue(String name, Object value, VariableSource source) {
        this.variableMap.put(name, value);
        if (source == VariableSource.CORE) {
            this.setChanged();
            this.notifyObservers(new Variable(name, value));
        }
    }

    public Object getValue(String name) {
        return this.variableMap.get(name);
    }

    public Map<String, Object> getModifiableMap(VariableSource source) {
        return new SourceMap(source);
    }

    private class SourceMap
    implements Map<String, Object> {
        private VariableSource source;

        public SourceMap(VariableSource source) {
            this.source = source;
        }

        @Override
        public int size() {
            return WoolVariableStore.this.variableMap.size();
        }

        @Override
        public boolean isEmpty() {
            return WoolVariableStore.this.variableMap.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return WoolVariableStore.this.variableMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return WoolVariableStore.this.variableMap.containsValue(value);
        }

        @Override
        public Object get(Object key) {
            return WoolVariableStore.this.variableMap.get(key);
        }

        @Override
        public Object put(String key, Object value) {
            Object result = this.get(key);
            WoolVariableStore.this.setValue(key, value, this.source);
            return result;
        }

        @Override
        public Object remove(Object key) {
            return WoolVariableStore.this.variableMap.remove(key);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            for (String string : m.keySet()) {
                WoolVariableStore.this.setValue(string, m.get(string), this.source);
            }
        }

        @Override
        public void clear() {
            WoolVariableStore.this.variableMap.clear();
        }

        @Override
        public Set<String> keySet() {
            return WoolVariableStore.this.variableMap.keySet();
        }

        @Override
        public Collection<Object> values() {
            return WoolVariableStore.this.variableMap.values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return WoolVariableStore.this.variableMap.entrySet();
        }
    }

    public class Variable {
        private String name;
        private Object value;

        public Variable(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getVariableName() {
            return this.name;
        }

        public Object getVariableValue() {
            return this.value;
        }
    }

    public static enum VariableSource {
        CORE,
        EXTERNAL;

    }
}

