/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.expressions;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.rrd.wool.expressions.EvaluationException;
import nl.rrd.wool.json.JsonMapper;

@JsonSerialize(using=ValueSerializer.class)
@JsonDeserialize(using=ValueDeserializer.class)
public class Value {
    private Object value;

    public Value(Object value) throws IllegalArgumentException {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    public boolean isNumericString() {
        if (!this.isString()) {
            return false;
        }
        String s = (String)this.value;
        try {
            if (s.matches("-?[0-9]+")) {
                Long.parseLong(s);
            } else {
                Double.parseDouble(s);
            }
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public boolean isNumber() {
        return this.value instanceof Number;
    }

    public boolean isIntNumber() {
        return this.isNumber() && Value.isIntNumber((Number)this.value);
    }

    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    public boolean isList() {
        return this.value instanceof List;
    }

    public boolean isMap() {
        return this.value instanceof Map;
    }

    public Number asNumber() throws EvaluationException {
        if (this.value == null) {
            return 0;
        }
        if (this.value instanceof Number) {
            return Value.normalizeNumber((Number)this.value);
        }
        if (this.value instanceof String) {
            String s = (String)this.value;
            try {
                if (s.matches("-?[0-9]+")) {
                    long num = Long.parseLong(s);
                    return Value.normalizeNumber(num);
                }
                return Double.parseDouble(s);
            }
            catch (IllegalArgumentException ex) {
                throw new EvaluationException("Can't convert string to number: " + s);
            }
        }
        if (this.value instanceof Boolean) {
            boolean b = (Boolean)this.value;
            return b ? 1 : 0;
        }
        throw new EvaluationException(String.format("Can't convert %s to number", this.getTypeString()));
    }

    public boolean asBoolean() {
        if (this.value == null) {
            return false;
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        if (this.value instanceof String) {
            String s = (String)this.value;
            return s.length() > 0;
        }
        if (this.value instanceof Number) {
            Number n = (Number)this.value;
            if (Value.isIntNumber(n)) {
                return n.longValue() != 0L;
            }
            return n.doubleValue() != 0.0;
        }
        if (this.value instanceof List) {
            List list = (List)this.value;
            return !list.isEmpty();
        }
        if (this.value instanceof Map) {
            Map map = (Map)this.value;
            return !map.isEmpty();
        }
        throw new RuntimeException("Invalid value class: " + this.value.getClass().getName());
    }

    public boolean isEqual(Value other) {
        return Value.isEqual(this, other);
    }

    public boolean isStrictEqual(Value other) {
        return Value.isStrictEqual(this, other);
    }

    public String getTypeString() {
        if (this.value == null) {
            return "null";
        }
        if (this.value instanceof String) {
            return "string";
        }
        if (this.value instanceof Number) {
            return "number";
        }
        if (this.value instanceof Boolean) {
            return "boolean";
        }
        if (this.value instanceof List) {
            return "list";
        }
        if (this.value instanceof Map) {
            return "map";
        }
        throw new RuntimeException("Invalid value class: " + this.value.getClass().getName());
    }

    public String toString() {
        if (this.value == null) {
            return "null";
        }
        if (this.value instanceof String) {
            return (String)this.value;
        }
        if (this.value instanceof List) {
            return JsonMapper.generate(this.value);
        }
        if (this.value instanceof Map) {
            return JsonMapper.generate(this.value);
        }
        return this.value.toString();
    }

    public static boolean isIntNumber(Number number) {
        return number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long;
    }

    public static Number normalizeNumber(Number number) {
        if (Value.isIntNumber(number)) {
            long val = number.longValue();
            if (val >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE) {
                return (int)val;
            }
            return val;
        }
        return number.doubleValue();
    }

    private static boolean isEqual(Value val1, Value val2) {
        if (val1.isNull() || val2.isNull() || val1.isBoolean() || val2.isBoolean()) {
            return val1.asBoolean() == val2.asBoolean();
        }
        if (val1.isMap() || val2.isMap()) {
            if (!val1.isMap() || !val2.isMap()) {
                return false;
            }
            return Value.isEqualMaps((Map)val1.value, (Map)val2.value);
        }
        if (val1.isList() || val2.isList()) {
            List<Object> list1 = val1.isList() ? (List<Object>)val1.value : Collections.singletonList(val1.value);
            List<Object> list2 = val2.isList() ? (List<Object>)val2.value : Collections.singletonList(val2.value);
            return Value.isEqualLists(list1, list2);
        }
        if (val1.isString() || val2.isString()) {
            return val1.toString().equals(val2.toString());
        }
        try {
            return val1.asNumber().equals(val2.asNumber());
        }
        catch (EvaluationException ex) {
            throw new RuntimeException("Unexpected error: " + ex.getMessage(), ex);
        }
    }

    private static boolean isEqualLists(List<?> list1, List<?> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        Iterator<?> it1 = list1.iterator();
        Iterator<?> it2 = list2.iterator();
        while (it1.hasNext()) {
            Value val2;
            Value val1 = new Value(it1.next());
            if (val1.isEqual(val2 = new Value(it2.next()))) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqualMaps(Map<?, ?> map1, Map<?, ?> map2) {
        if (map1.size() != map1.size()) {
            return false;
        }
        for (Object key : map1.keySet()) {
            Value val2;
            if (!map2.containsKey(key)) {
                return false;
            }
            Value val1 = new Value(map1.get(key));
            if (val1.isEqual(val2 = new Value(map2.get(key)))) continue;
            return false;
        }
        return true;
    }

    private static boolean isStrictEqual(Value val1, Value val2) {
        if (val1.isNull()) {
            return val2.isNull();
        }
        if (val1.isBoolean()) {
            return val2.isBoolean() && val1.asBoolean() == val2.asBoolean();
        }
        if (val1.isString()) {
            return val2.isString() && val1.toString().equals(val2.toString());
        }
        if (val1.isNumber()) {
            try {
                return val2.isNumber() && val1.asNumber().equals(val2.asNumber());
            }
            catch (EvaluationException ex) {
                throw new RuntimeException("Unexpected error: " + ex.getMessage(), ex);
            }
        }
        if (val1.isList()) {
            return val2.isList() && Value.isStrictEqualLists((List)val1.value, (List)val2.value);
        }
        return val2.isMap() && Value.isStrictEqualMaps((Map)val1.value, (Map)val2.value);
    }

    private static boolean isStrictEqualLists(List<?> list1, List<?> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        Iterator<?> it1 = list1.iterator();
        Iterator<?> it2 = list2.iterator();
        while (it1.hasNext()) {
            Value val2;
            Value val1 = new Value(it1.next());
            if (val1.isStrictEqual(val2 = new Value(it2.next()))) continue;
            return false;
        }
        return true;
    }

    private static boolean isStrictEqualMaps(Map<?, ?> map1, Map<?, ?> map2) {
        if (map1.size() != map1.size()) {
            return false;
        }
        for (Object key : map1.keySet()) {
            Value val2;
            if (!map2.containsKey(key)) {
                return false;
            }
            Value val1 = new Value(map1.get(key));
            if (val1.isStrictEqual(val2 = new Value(map2.get(key)))) continue;
            return false;
        }
        return true;
    }

    static class ValueDeserializer
    extends JsonDeserializer<Value> {
        ValueDeserializer() {
        }

        public Value deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            Object value = p.readValueAs(Object.class);
            return new Value(value);
        }
    }

    static class ValueSerializer
    extends JsonSerializer<Value> {
        ValueSerializer() {
        }

        public void serialize(Value value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeObject(value.value);
        }
    }
}

