/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.expressions.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.rrd.wool.expressions.EvaluationException;
import nl.rrd.wool.expressions.Expression;
import nl.rrd.wool.expressions.Value;

public class AddExpression
implements Expression {
    private Expression operand1;
    private Expression operand2;

    public AddExpression(Expression operand1, Expression operand2) {
        this.operand1 = operand1;
        this.operand2 = operand2;
    }

    public Expression getOperand1() {
        return this.operand1;
    }

    public Expression getOperand2() {
        return this.operand2;
    }

    @Override
    public Value evaluate(Map<String, Object> variables) throws EvaluationException {
        Value val1 = this.operand1.evaluate(variables);
        Value val2 = this.operand2.evaluate(variables);
        if (val1.isMap() || val2.isMap()) {
            return this.mergeMaps(val1, val2);
        }
        if (val1.isList() || val2.isList()) {
            return this.mergeLists(val1, val2);
        }
        if (val1.isString() || val2.isString()) {
            return new Value(val1.toString() + val2.toString());
        }
        Number num1 = val1.asNumber();
        Number num2 = val2.asNumber();
        if (Value.isIntNumber(num1) && Value.isIntNumber(num2)) {
            return new Value(Value.normalizeNumber(num1.longValue() + num2.longValue()));
        }
        return new Value(num1.doubleValue() + num2.doubleValue());
    }

    private Value mergeMaps(Value val1, Value val2) throws EvaluationException {
        Value nonMap = null;
        if (!val1.isMap()) {
            nonMap = val1;
        } else if (!val2.isMap()) {
            nonMap = val2;
        }
        if (nonMap != null) {
            throw new EvaluationException("Can't add map and " + nonMap.getTypeString());
        }
        LinkedHashMap result = new LinkedHashMap();
        Map map1 = (Map)val1.getValue();
        Map map2 = (Map)val2.getValue();
        for (Object key : map1.keySet()) {
            result.put((String)key, map1.get(key));
        }
        for (Object key : map2.keySet()) {
            result.put((String)key, map2.get(key));
        }
        return new Value(result);
    }

    private Value mergeLists(Value val1, Value val2) {
        List<Object> list1 = val1.isList() ? (List<Object>)val1.getValue() : Collections.singletonList(val1.getValue());
        List<Object> list2 = val2.isList() ? (List<Object>)val2.getValue() : Collections.singletonList(val2.getValue());
        ArrayList<Object> result = new ArrayList<Object>(list1);
        result.addAll(list2);
        return new Value(result);
    }

    @Override
    public List<Expression> getChildren() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        result.add(this.operand1);
        result.add(this.operand2);
        return result;
    }

    @Override
    public List<Expression> getDescendants() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        for (Expression child : this.getChildren()) {
            result.add(child);
            result.addAll(child.getDescendants());
        }
        return result;
    }

    @Override
    public Set<String> getVariableNames() {
        HashSet<String> result = new HashSet<String>();
        for (Expression child : this.getChildren()) {
            result.addAll(child.getVariableNames());
        }
        return result;
    }

    public String toString() {
        return this.operand1 + " + " + this.operand2;
    }
}

