/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.expressions.types;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.rrd.wool.expressions.EvaluationException;
import nl.rrd.wool.expressions.Expression;
import nl.rrd.wool.expressions.Value;

public class SubtractExpression
implements Expression {
    private Expression operand1;
    private Expression operand2;

    public SubtractExpression(Expression operand1, Expression operand2) {
        this.operand1 = operand1;
        this.operand2 = operand2;
    }

    public Expression getOperand1() {
        return this.operand1;
    }

    public Expression getOperand2() {
        return this.operand2;
    }

    @Override
    public Value evaluate(Map<String, Object> variables) throws EvaluationException {
        Value val1 = this.operand1.evaluate(variables);
        Value val2 = this.operand2.evaluate(variables);
        if (val1.isMap()) {
            Map map = (Map)val1.getValue();
            if (val2.isList()) {
                this.subtractMap(map, (List)val2.getValue());
            } else {
                this.removeFromMap(map, val2);
            }
            return new Value(map);
        }
        if (val1.isList()) {
            List list = (List)val1.getValue();
            if (val2.isList()) {
                this.subtractList(list, (List)val2.getValue());
            } else {
                this.removeFromList(list, val2);
            }
            return new Value(list);
        }
        Number num1 = val1.asNumber();
        Number num2 = val2.asNumber();
        if (Value.isIntNumber(num1) && Value.isIntNumber(num2)) {
            return new Value(Value.normalizeNumber(num1.longValue() - num2.longValue()));
        }
        return new Value(num1.doubleValue() - num2.doubleValue());
    }

    private void subtractMap(Map<?, ?> map, List<?> removeList) throws EvaluationException {
        for (Object item : removeList) {
            Value itemVal = new Value(item);
            this.removeFromMap(map, itemVal);
        }
    }

    private void removeFromMap(Map<?, ?> map, Value val) throws EvaluationException {
        if (!val.isString() && !val.isNumber()) {
            throw new EvaluationException("Remove key from map must be a string or number, found: " + val.getTypeString());
        }
        String key = val.toString();
        map.remove(key);
    }

    private void subtractList(List<?> list, List<?> removeList) {
        for (Object item : removeList) {
            Value itemVal = new Value(item);
            this.removeFromList(list, itemVal);
        }
    }

    private void removeFromList(List<?> list, Value val) {
        int i = 0;
        while (i < list.size()) {
            Value item = new Value(list.get(i));
            if (item.isEqual(val)) {
                list.remove(i);
                continue;
            }
            ++i;
        }
    }

    @Override
    public List<Expression> getChildren() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        result.add(this.operand1);
        result.add(this.operand2);
        return result;
    }

    @Override
    public List<Expression> getDescendants() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        for (Expression child : this.getChildren()) {
            result.add(child);
            result.addAll(child.getDescendants());
        }
        return result;
    }

    @Override
    public Set<String> getVariableNames() {
        HashSet<String> result = new HashSet<String>();
        for (Expression child : this.getChildren()) {
            result.addAll(child.getVariableNames());
        }
        return result;
    }

    public String toString() {
        return this.operand1 + " - " + this.operand2;
    }
}

