/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.io;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class LineColumnNumberReader
extends Reader {
    private Reader reader;
    private long position = 0L;
    private char[] buffer;
    private int bufferOff = 0;
    private int bufferLen = 0;
    private State state = new State();
    private char[] resetBuffer = null;
    private int resetOff = 0;
    private List<RestoreState> restoreStates = new ArrayList<RestoreState>();
    private RestoreState markState = null;

    public LineColumnNumberReader(Reader reader) {
        this.reader = reader;
        this.buffer = new char[4096];
    }

    @Override
    public void close() throws IOException {
        this.restoreStates.clear();
        this.markState = null;
        this.resetBuffer = null;
        this.buffer = null;
        this.bufferLen = 0;
        this.reader.close();
    }

    public long getPosition() {
        return this.position;
    }

    public int getLineNum() {
        return this.state.lineNum;
    }

    public int getColNum() {
        return this.state.colNum;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int copyLen;
        int nread = 0;
        if (nread < len && this.resetBuffer != null) {
            copyLen = len;
            if (this.resetBuffer.length - this.resetOff < copyLen) {
                copyLen = this.resetBuffer.length - this.resetOff;
            }
            System.arraycopy(this.resetBuffer, this.resetOff, cbuf, off, copyLen);
            nread += copyLen;
            this.resetOff += copyLen;
            if (this.resetOff == this.resetBuffer.length) {
                this.resetBuffer = null;
                this.resetOff = 0;
            }
        }
        while (this.bufferLen >= 0 && nread < len) {
            if (this.bufferOff == this.bufferLen) {
                this.bufferOff = 0;
                this.bufferLen = this.reader.read(this.buffer, 0, this.buffer.length);
                if (this.bufferLen <= 0) break;
            }
            if (this.bufferLen - this.bufferOff < (copyLen = len - nread)) {
                copyLen = this.bufferLen - this.bufferOff;
            }
            System.arraycopy(this.buffer, this.bufferOff, cbuf, off + nread, copyLen);
            nread += copyLen;
            this.bufferOff += copyLen;
        }
        if (nread == 0) {
            return this.bufferLen < 0 ? this.bufferLen : 0;
        }
        if (this.markState != null) {
            this.updateRestoreStateAfterRead(this.markState, this.position, cbuf, off, nread);
        }
        for (RestoreState restoreState : this.restoreStates) {
            this.updateRestoreStateAfterRead(restoreState, this.position, cbuf, off, nread);
        }
        for (int i = 0; i < nread; ++i) {
            char c = cbuf[off + i];
            if (c == '\r') {
                ++this.state.lineNum;
                this.state.colNum = 1;
                this.state.isPrevCR = true;
                continue;
            }
            if (c == '\n') {
                if (this.state.isPrevCR) {
                    this.state.isPrevCR = false;
                    continue;
                }
                ++this.state.lineNum;
                this.state.colNum = 1;
                continue;
            }
            if (this.state.isPrevCR) {
                this.state.isPrevCR = false;
            }
            ++this.state.colNum;
        }
        this.position += (long)nread;
        return nread;
    }

    private void updateRestoreStateAfterRead(RestoreState restoreState, long position, char[] cbuf, int off, int len) {
        int srcStart = off;
        int copyLen = len;
        if (position < restoreState.markPos) {
            int diff = (int)(restoreState.markPos - position);
            srcStart += diff;
            if ((copyLen -= diff) <= 0) {
                return;
            }
        }
        this.appendToMarkBuffer(restoreState, cbuf, srcStart, copyLen);
    }

    @Override
    public boolean ready() throws IOException {
        if (this.resetBuffer != null || this.bufferOff < this.bufferLen) {
            return true;
        }
        return super.ready();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        RestoreFixedState restoreState = new RestoreFixedState();
        restoreState.markPos = this.position;
        restoreState.markState = new State(this.state);
        restoreState.markBuffer = new char[readAheadLimit];
        restoreState.markOff = 0;
        this.markState = restoreState;
    }

    @Override
    public void reset() throws IOException {
        if (this.markState == null) {
            throw new IOException("Reset failed: mark not set or already reset");
        }
        this.doRestoreState(this.markState);
        this.markState = null;
    }

    public Object getRestoreState() {
        RestoreDynamicState restoreState = new RestoreDynamicState();
        restoreState.markPos = this.position;
        restoreState.markState = new State(this.state);
        restoreState.markBuffer = new StringBuilder();
        this.restoreStates.add(restoreState);
        return restoreState;
    }

    public Object getRestoreState(int readAheadLimit) {
        RestoreFixedState restoreState = new RestoreFixedState();
        restoreState.markPos = this.position;
        restoreState.markState = new State(this.state);
        restoreState.markBuffer = new char[readAheadLimit];
        restoreState.markOff = 0;
        this.restoreStates.add(restoreState);
        return restoreState;
    }

    public void reinitRestoreState(Object state) {
        RestoreState restoreState = (RestoreState)state;
        restoreState.markPos = this.position;
        restoreState.markState.set(this.state);
        if (state instanceof RestoreDynamicState) {
            RestoreDynamicState dynState = (RestoreDynamicState)state;
            dynState.markBuffer.delete(0, dynState.markBuffer.length());
        } else {
            RestoreFixedState fixedState = (RestoreFixedState)state;
            fixedState.markOff = 0;
        }
    }

    public void clearRestoreState(Object savedState) {
        this.restoreStates.remove(savedState);
    }

    public void restoreState(Object savedState) throws IOException {
        if (!this.restoreStates.contains(savedState)) {
            throw new IOException("Restore state failed: cleared or already restored");
        }
        RestoreState restoreState = (RestoreState)savedState;
        this.doRestoreState(restoreState);
        this.restoreStates.remove(restoreState);
    }

    private void doRestoreState(RestoreState restoreState) throws IOException {
        if (this.markState != null && this.markState != restoreState) {
            this.updateRestoreStatePosition(this.markState, restoreState.markPos);
        }
        for (RestoreState other : this.restoreStates) {
            if (other == restoreState) continue;
            this.updateRestoreStatePosition(other, restoreState.markPos);
        }
        if (restoreState.markPos < this.position) {
            this.prependMarkBufferToResetBuffer(restoreState);
        } else if (restoreState.markPos > this.position) {
            int len = (int)(restoreState.markPos - this.position);
            this.resetOff += len;
            if (this.resetOff == this.resetBuffer.length) {
                this.resetBuffer = null;
                this.resetOff = 0;
            }
        }
        this.state = restoreState.markState;
        this.position = restoreState.markPos;
    }

    private void updateRestoreStatePosition(RestoreState restoreState, long newPos) {
        if (newPos > this.position && newPos > restoreState.markPos) {
            int srcStart;
            int len;
            int posMoveLen = (int)(newPos - this.position);
            if (this.position < restoreState.markPos) {
                len = (int)(newPos - restoreState.markPos);
                srcStart = this.resetOff + posMoveLen - len;
            } else {
                len = posMoveLen;
                srcStart = this.resetOff;
            }
            this.appendToMarkBuffer(restoreState, this.resetBuffer, srcStart, len);
        } else if (newPos < this.position && this.position > restoreState.markPos) {
            int posMoveLen = (int)(this.position - newPos);
            int len = newPos < restoreState.markPos ? (int)(this.position - restoreState.markPos) : posMoveLen;
            this.removeFromMarkBufferEnd(restoreState, len);
        }
    }

    private void appendToMarkBuffer(RestoreState restoreState, char[] cbuf, int off, int len) {
        if (restoreState instanceof RestoreFixedState) {
            int toCopy;
            RestoreFixedState fixedState = (RestoreFixedState)restoreState;
            int bufRemain = fixedState.markBuffer.length - fixedState.markOff;
            int n = toCopy = len < bufRemain ? len : bufRemain;
            if (toCopy > 0) {
                System.arraycopy(cbuf, off, fixedState.markBuffer, fixedState.markOff, toCopy);
            }
            fixedState.markOff += len;
        } else {
            RestoreDynamicState dynState = (RestoreDynamicState)restoreState;
            dynState.markBuffer.append(cbuf, off, len);
        }
    }

    private void removeFromMarkBufferEnd(RestoreState restoreState, int len) {
        if (restoreState instanceof RestoreFixedState) {
            RestoreFixedState fixedState = (RestoreFixedState)restoreState;
            fixedState.markOff -= len;
        } else {
            RestoreDynamicState dynState = (RestoreDynamicState)restoreState;
            int buflen = dynState.markBuffer.length();
            dynState.markBuffer.delete(buflen - len, buflen);
        }
    }

    private void prependMarkBufferToResetBuffer(RestoreState restoreState) throws IOException {
        int copyLen;
        int mergedLen = copyLen = (int)(this.position - restoreState.markPos);
        if (this.resetBuffer != null) {
            mergedLen = copyLen + this.resetBuffer.length - this.resetOff;
        }
        char[] merged = new char[mergedLen];
        if (restoreState instanceof RestoreFixedState) {
            RestoreFixedState fixedState = (RestoreFixedState)restoreState;
            if (copyLen > fixedState.markBuffer.length) {
                String fn = restoreState == this.markState ? "Reset" : "Restore state";
                throw new IOException(fn + " failed: fixed buffer overflown");
            }
            System.arraycopy(fixedState.markBuffer, 0, merged, 0, copyLen);
        } else {
            RestoreDynamicState dynState = (RestoreDynamicState)restoreState;
            dynState.markBuffer.getChars(0, dynState.markBuffer.length(), merged, 0);
        }
        if (this.resetBuffer != null) {
            System.arraycopy(this.resetBuffer, this.resetOff, merged, copyLen, this.resetBuffer.length - this.resetOff);
        }
        this.resetBuffer = merged;
        this.resetOff = 0;
    }

    private class RestoreDynamicState
    extends RestoreState {
        public StringBuilder markBuffer;

        private RestoreDynamicState() {
        }
    }

    private class RestoreFixedState
    extends RestoreState {
        public char[] markBuffer;
        public int markOff;

        private RestoreFixedState() {
        }
    }

    private abstract class RestoreState {
        public long markPos;
        public State markState;

        private RestoreState() {
        }
    }

    private class State {
        public boolean isPrevCR = false;
        public int lineNum = 1;
        public int colNum = 1;

        public State() {
        }

        public State(State other) {
            this.set(other);
        }

        public void set(State other) {
            this.isPrevCR = other.isPrevCR;
            this.lineNum = other.lineNum;
            this.colNum = other.colNum;
        }
    }
}

