/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.rrd.wool.model.WoolNode;
import nl.rrd.wool.model.nodepointer.WoolNodePointer;
import nl.rrd.wool.model.nodepointer.WoolNodePointerExternal;

public class WoolDialogue {
    private String dialogueName;
    private Map<String, WoolNode> nodes = new LinkedHashMap<String, WoolNode>();
    private Set<String> speakers = new HashSet<String>();
    private Set<String> variablesNeeded = new HashSet<String>();
    private Set<String> variablesWritten = new HashSet<String>();
    private Set<String> dialoguesReferenced = new HashSet<String>();

    public WoolDialogue() {
    }

    public WoolDialogue(String dialogueName) {
        this.dialogueName = dialogueName;
    }

    public String getDialogueName() {
        return this.dialogueName;
    }

    public WoolNode getStartNode() {
        return this.nodes.get("start");
    }

    public List<WoolNode> getNodes() {
        return Collections.unmodifiableList(new ArrayList<WoolNode>(this.nodes.values()));
    }

    public void addNode(WoolNode node) {
        this.nodes.put(node.getTitle().toLowerCase(), node);
        if (node.getHeader().getSpeaker() != null) {
            this.speakers.add(node.getHeader().getSpeaker());
        }
        node.getBody().getReadVariableNames(this.variablesNeeded);
        node.getBody().getWriteVariableNames(this.variablesWritten);
        HashSet<WoolNodePointer> nodePointers = new HashSet<WoolNodePointer>();
        node.getBody().getNodePointers(nodePointers);
        for (WoolNodePointer nodePointer : nodePointers) {
            if (!(nodePointer instanceof WoolNodePointerExternal)) continue;
            WoolNodePointerExternal extPointer = (WoolNodePointerExternal)nodePointer;
            this.dialoguesReferenced.add(extPointer.getDialogueId());
        }
    }

    public Set<String> getSpeakers() {
        return Collections.unmodifiableSet(this.speakers);
    }

    public List<String> getSpeakersList() {
        ArrayList<String> speakersList = new ArrayList<String>(this.speakers);
        Collections.sort(speakersList);
        return Collections.unmodifiableList(speakersList);
    }

    public Set<String> getVariablesNeeded() {
        return Collections.unmodifiableSet(this.variablesNeeded);
    }

    public Set<String> getVariablesWritten() {
        return Collections.unmodifiableSet(this.variablesWritten);
    }

    public Set<String> getDialoguesReferenced() {
        return Collections.unmodifiableSet(this.dialoguesReferenced);
    }

    public void setDialogueName(String dialogueName) {
        this.dialogueName = dialogueName;
    }

    public boolean nodeExists(String nodeId) {
        return this.nodes.containsKey(nodeId.toLowerCase());
    }

    public WoolNode getNodeById(String nodeId) {
        return this.nodes.get(nodeId.toLowerCase());
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public int getSpeakerCount() {
        return this.speakers.size();
    }

    public int getDialoguesReferencedCount() {
        return this.dialoguesReferenced.size();
    }

    public int getVariablesNeededCount() {
        return this.variablesNeeded.size();
    }

    public int getVariablesWrittenCount() {
        return this.variablesWritten.size();
    }

    public String toString() {
        String summaryString = "";
        summaryString = summaryString + "Dialogue Name: " + this.getDialogueName() + "\n";
        summaryString = summaryString + "Number of Nodes: " + this.getNodeCount() + "\n";
        summaryString = summaryString + "\n";
        summaryString = summaryString + "Speakers present (" + this.getSpeakerCount() + "):\n";
        for (String s : this.getSpeakers()) {
            summaryString = summaryString + "  - " + s + "\n";
        }
        summaryString = summaryString + "Dialogues referenced (" + this.getDialoguesReferencedCount() + "):\n";
        ArrayList<String> names = new ArrayList<String>(this.getDialoguesReferenced());
        Collections.sort(names);
        for (String s : names) {
            summaryString = summaryString + "  - " + s + "\n";
        }
        summaryString = summaryString + "Variables needed (" + this.getVariablesNeededCount() + "):\n";
        names = new ArrayList<String>(this.getVariablesNeeded());
        Collections.sort(names);
        for (String s : names) {
            summaryString = summaryString + "  - " + s + "\n";
        }
        summaryString = summaryString + "Variables written (" + this.getVariablesWrittenCount() + "):\n";
        names = new ArrayList<String>(this.getVariablesWritten());
        Collections.sort(names);
        for (String s : names) {
            summaryString = summaryString + "  - " + s + "\n";
        }
        return summaryString;
    }
}

