/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.rrd.wool.expressions.EvaluationException;
import nl.rrd.wool.model.WoolReply;
import nl.rrd.wool.model.WoolVariableString;
import nl.rrd.wool.model.command.WoolCommand;
import nl.rrd.wool.model.nodepointer.WoolNodePointer;
import nl.rrd.wool.model.nodepointer.WoolNodePointerExternal;
import nl.rrd.wool.model.nodepointer.WoolNodePointerInternal;

public class WoolNodeBody {
    private List<Segment> segments = new ArrayList<Segment>();
    private List<WoolReply> replies = new ArrayList<WoolReply>();

    public List<Segment> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public void addSegment(Segment segment) {
        Segment lastSegment = null;
        if (!this.segments.isEmpty()) {
            lastSegment = this.segments.get(this.segments.size() - 1);
        }
        if (lastSegment instanceof TextSegment && segment instanceof TextSegment) {
            TextSegment lastTextSegment = (TextSegment)lastSegment;
            TextSegment textSegment = (TextSegment)segment;
            WoolVariableString text = new WoolVariableString();
            text.addSegments(lastTextSegment.text.getSegments());
            text.addSegments(textSegment.text.getSegments());
            TextSegment mergedSegment = new TextSegment(text);
            this.segments.remove(this.segments.size() - 1);
            this.segments.add(mergedSegment);
        } else {
            this.segments.add(segment);
        }
    }

    private void normalizeWhitespace(boolean trimText) {
        TextSegment lastText = null;
        String currLine = null;
        Iterator<Segment> it = this.segments.iterator();
        while (it.hasNext()) {
            String line;
            int index;
            TextSegment textSegment;
            Segment segment = it.next();
            if (!(segment instanceof TextSegment)) continue;
            lastText = textSegment = (TextSegment)segment;
            String text = textSegment.text.evaluate(null);
            text = text.replaceAll("[\r\n]+", "\n").replaceAll("[\t ]+", " ");
            StringBuilder normText = new StringBuilder();
            int start = 0;
            while ((index = text.indexOf(10, start)) != -1) {
                line = text.substring(start, index).trim();
                if (currLine != null && line.isEmpty()) {
                    normText.append("\n");
                } else if (currLine != null) {
                    normText.append(" " + line + "\n");
                } else if (!line.isEmpty()) {
                    normText.append(line + "\n");
                }
                currLine = null;
                start = index + 1;
            }
            line = text.substring(start).trim();
            if (!line.isEmpty()) {
                if (currLine != null) {
                    currLine = currLine + " " + line;
                    normText.append(" " + line);
                } else {
                    currLine = line;
                    normText.append(line);
                }
            }
            if (normText.length() == 0) {
                it.remove();
                continue;
            }
            textSegment.text = new WoolVariableString(normText.toString());
        }
        if (trimText && lastText != null) {
            String text = lastText.text.evaluate(null).replaceAll("\\s+$", "");
            lastText.text = new WoolVariableString(text);
        }
    }

    public List<WoolReply> getReplies() {
        return this.replies;
    }

    public WoolReply findReplyById(int replyId) {
        for (WoolReply reply : this.replies) {
            if (reply.getReplyId() != replyId) continue;
            return reply;
        }
        for (Segment segment : this.segments) {
            WoolReply reply = segment.findReplyById(replyId);
            if (reply == null) continue;
            return reply;
        }
        return null;
    }

    public void addReply(WoolReply reply) {
        this.replies.add(reply);
    }

    public List<String> getReadVariableNames() {
        HashSet<String> set = new HashSet<String>();
        this.getReadVariableNames(set);
        ArrayList<String> result = new ArrayList<String>(set);
        Collections.sort(result);
        return result;
    }

    public void getReadVariableNames(Set<String> varNames) {
        for (Segment segment : this.segments) {
            segment.getReadVariableNames(varNames);
        }
        for (WoolReply reply : this.replies) {
            reply.getReadVariableNames(varNames);
        }
    }

    public List<String> getWriteVariableNames() {
        HashSet<String> set = new HashSet<String>();
        this.getWriteVariableNames(set);
        ArrayList<String> result = new ArrayList<String>(set);
        Collections.sort(result);
        return result;
    }

    public void getWriteVariableNames(Set<String> varNames) {
        for (Segment segment : this.segments) {
            segment.getWriteVariableNames(varNames);
        }
        for (WoolReply reply : this.replies) {
            reply.getWriteVariableNames(varNames);
        }
    }

    public List<WoolNodePointer> getNodePointers() {
        HashSet<WoolNodePointer> set = new HashSet<WoolNodePointer>();
        this.getNodePointers(set);
        ArrayList<WoolNodePointer> result = new ArrayList<WoolNodePointer>(set);
        Collections.sort(result, new Comparator<WoolNodePointer>(){

            @Override
            public int compare(WoolNodePointer o1, WoolNodePointer o2) {
                return WoolNodeBody.this.compareNodePointers(o1, o2);
            }
        });
        return result;
    }

    private int compareNodePointers(WoolNodePointer o1, WoolNodePointer o2) {
        if (o1 instanceof WoolNodePointerInternal) {
            if (o2 instanceof WoolNodePointerExternal) {
                return -1;
            }
            WoolNodePointerInternal p1 = (WoolNodePointerInternal)o1;
            WoolNodePointerInternal p2 = (WoolNodePointerInternal)o2;
            return p1.getNodeId().compareTo(p2.getNodeId());
        }
        if (o2 instanceof WoolNodePointerInternal) {
            return -1;
        }
        WoolNodePointerExternal p1 = (WoolNodePointerExternal)o1;
        WoolNodePointerExternal p2 = (WoolNodePointerExternal)o2;
        int result = p1.getDialogueId().compareTo(p2.getDialogueId());
        if (result != 0) {
            return result;
        }
        return p1.getNodeId().compareTo(p2.getNodeId());
    }

    public void getNodePointers(Set<WoolNodePointer> pointers) {
        for (Segment segment : this.segments) {
            if (!(segment instanceof CommandSegment)) continue;
            WoolCommand command = ((CommandSegment)segment).command;
            command.getNodePointers(pointers);
        }
        for (WoolReply reply : this.replies) {
            pointers.add(reply.getNodePointer());
        }
    }

    public void execute(Map<String, Object> variables, boolean trimText, WoolNodeBody processedBody) throws EvaluationException {
        for (Segment segment : this.segments) {
            if (segment instanceof TextSegment) {
                this.executeTextSegment((TextSegment)segment, variables, processedBody);
                continue;
            }
            this.executeCommandSegment((CommandSegment)segment, variables, processedBody);
        }
        for (WoolReply reply : this.replies) {
            processedBody.addReply(reply.execute(variables));
        }
        processedBody.normalizeWhitespace(trimText);
    }

    private void executeTextSegment(TextSegment segment, Map<String, Object> variables, WoolNodeBody processedBody) {
        TextSegment processedText = new TextSegment(segment.text.execute(variables));
        processedBody.addSegment(processedText);
    }

    private void executeCommandSegment(CommandSegment segment, Map<String, Object> variables, WoolNodeBody processedBody) throws EvaluationException {
        segment.command.executeBodyCommand(variables, processedBody);
    }

    public void trimWhitespace() {
        this.removeLeadingWhitespace();
        this.removeTrailingWhitespace();
    }

    public void removeLeadingWhitespace() {
        while (!this.segments.isEmpty()) {
            Segment segment = this.segments.get(0);
            if (!(segment instanceof TextSegment)) {
                return;
            }
            TextSegment textSegment = (TextSegment)segment;
            WoolVariableString text = textSegment.getText();
            text.removeLeadingWhitespace();
            if (!text.getSegments().isEmpty()) {
                return;
            }
            this.segments.remove(0);
        }
    }

    public void removeTrailingWhitespace() {
        while (!this.segments.isEmpty()) {
            Segment segment = this.segments.get(this.segments.size() - 1);
            if (!(segment instanceof TextSegment)) {
                return;
            }
            TextSegment textSegment = (TextSegment)segment;
            WoolVariableString text = textSegment.getText();
            text.removeTrailingWhitespace();
            if (!text.getSegments().isEmpty()) {
                return;
            }
            this.segments.remove(this.segments.size() - 1);
        }
    }

    public String toString() {
        String newline = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        for (Segment segment : this.segments) {
            builder.append(segment.toString());
        }
        for (WoolReply reply : this.replies) {
            builder.append(newline);
            builder.append(reply);
        }
        return builder.toString();
    }

    public static class CommandSegment
    extends Segment {
        private WoolCommand command;

        public CommandSegment(WoolCommand command) {
            this.command = command;
        }

        public WoolCommand getCommand() {
            return this.command;
        }

        @Override
        public WoolReply findReplyById(int replyId) {
            return this.command.findReplyById(replyId);
        }

        @Override
        public void getReadVariableNames(Set<String> varNames) {
            this.command.getReadVariableNames(varNames);
        }

        @Override
        public void getWriteVariableNames(Set<String> varNames) {
            this.command.getWriteVariableNames(varNames);
        }

        public String toString() {
            return this.command.toString();
        }
    }

    public static class TextSegment
    extends Segment {
        private WoolVariableString text;

        public TextSegment(WoolVariableString text) {
            this.text = text;
        }

        public WoolVariableString getText() {
            return this.text;
        }

        public void setText(WoolVariableString text) {
            this.text = text;
        }

        @Override
        public WoolReply findReplyById(int replyId) {
            return null;
        }

        @Override
        public void getReadVariableNames(Set<String> varNames) {
            this.text.getReadVariableNames(varNames);
        }

        @Override
        public void getWriteVariableNames(Set<String> varNames) {
        }

        public String toString() {
            return this.text.toString();
        }
    }

    public static abstract class Segment {
        public abstract WoolReply findReplyById(int var1);

        public abstract void getReadVariableNames(Set<String> var1);

        public abstract void getWriteVariableNames(Set<String> var1);
    }
}

