/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.rrd.wool.expressions.EvaluationException;
import nl.rrd.wool.model.WoolNodeBody;
import nl.rrd.wool.model.command.WoolCommand;
import nl.rrd.wool.model.nodepointer.WoolNodePointer;

public class WoolReply {
    private int replyId;
    private WoolNodeBody statement = null;
    private WoolNodePointer nodePointer;
    private List<WoolCommand> commands = new ArrayList<WoolCommand>();

    public WoolReply(int replyId, WoolNodeBody statement, WoolNodePointer nodePointer) {
        this.replyId = replyId;
        this.statement = statement;
        this.nodePointer = nodePointer;
    }

    public WoolReply(int replyId, WoolNodePointer nodePointer) {
        this.replyId = replyId;
        this.nodePointer = nodePointer;
    }

    public int getReplyId() {
        return this.replyId;
    }

    public void setReplyId(int replyId) {
        this.replyId = replyId;
    }

    public WoolNodeBody getStatement() {
        return this.statement;
    }

    public void setStatement(WoolNodeBody statement) {
        this.statement = statement;
    }

    public WoolNodePointer getNodePointer() {
        return this.nodePointer;
    }

    public void setNodePointer(WoolNodePointer nodePointer) {
        this.nodePointer = nodePointer;
    }

    public List<WoolCommand> getCommands() {
        return this.commands;
    }

    public void setCommands(List<WoolCommand> commands) {
        this.commands = commands;
    }

    public void addCommand(WoolCommand command) {
        this.commands.add(command);
    }

    public void getReadVariableNames(Set<String> varNames) {
        if (this.statement != null) {
            this.statement.getReadVariableNames(varNames);
        }
        for (WoolCommand command : this.commands) {
            command.getReadVariableNames(varNames);
        }
    }

    public void getWriteVariableNames(Set<String> varNames) {
        if (this.statement != null) {
            this.statement.getWriteVariableNames(varNames);
        }
        for (WoolCommand command : this.commands) {
            command.getWriteVariableNames(varNames);
        }
    }

    public WoolReply execute(Map<String, Object> variables) throws EvaluationException {
        if (this.statement == null) {
            return this;
        }
        WoolNodeBody processedStatement = new WoolNodeBody();
        this.statement.execute(variables, false, processedStatement);
        WoolReply result = new WoolReply(this.replyId, processedStatement, this.nodePointer);
        result.commands = this.commands;
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[[");
        if (this.statement != null) {
            result.append(this.statement + "|");
        }
        result.append(this.nodePointer.toString());
        if (!this.commands.isEmpty()) {
            result.append("|");
            for (WoolCommand command : this.commands) {
                result.append(command.toString());
            }
        }
        result.append("]]");
        return result.toString();
    }
}

