/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.model.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.rrd.wool.exception.LineNumberParseException;
import nl.rrd.wool.expressions.EvaluationException;
import nl.rrd.wool.expressions.Expression;
import nl.rrd.wool.expressions.Value;
import nl.rrd.wool.expressions.types.AssignExpression;
import nl.rrd.wool.model.WoolNodeBody;
import nl.rrd.wool.model.WoolReply;
import nl.rrd.wool.model.command.WoolExpressionCommand;
import nl.rrd.wool.model.nodepointer.WoolNodePointer;
import nl.rrd.wool.parser.WoolBodyParser;
import nl.rrd.wool.parser.WoolBodyToken;
import nl.rrd.wool.parser.WoolNodeState;
import nl.rrd.wool.utils.CurrentIterator;

public class WoolIfCommand
extends WoolExpressionCommand {
    private List<Clause> ifClauses = new ArrayList<Clause>();
    private WoolNodeBody elseClause = null;

    public List<Clause> getIfClauses() {
        return this.ifClauses;
    }

    public void setIfClauses(List<Clause> ifClauses) {
        this.ifClauses = ifClauses;
    }

    public void addIfClause(Clause ifClause) {
        this.ifClauses.add(ifClause);
    }

    public WoolNodeBody getElseClause() {
        return this.elseClause;
    }

    public void setElseClause(WoolNodeBody elseClause) {
        this.elseClause = elseClause;
    }

    @Override
    public WoolReply findReplyById(int replyId) {
        for (Clause clause : this.ifClauses) {
            WoolReply reply = clause.statement.findReplyById(replyId);
            if (reply == null) continue;
            return reply;
        }
        if (this.elseClause != null) {
            return this.elseClause.findReplyById(replyId);
        }
        return null;
    }

    @Override
    public void getReadVariableNames(Set<String> varNames) {
        for (Clause clause : this.ifClauses) {
            varNames.addAll(clause.expression.getVariableNames());
            clause.statement.getReadVariableNames(varNames);
        }
        if (this.elseClause != null) {
            this.elseClause.getReadVariableNames(varNames);
        }
    }

    @Override
    public void getWriteVariableNames(Set<String> varNames) {
        for (Clause clause : this.ifClauses) {
            clause.statement.getWriteVariableNames(varNames);
        }
        if (this.elseClause != null) {
            this.elseClause.getWriteVariableNames(varNames);
        }
    }

    @Override
    public void getNodePointers(Set<WoolNodePointer> pointers) {
        for (Clause clause : this.ifClauses) {
            clause.statement.getNodePointers(pointers);
        }
        if (this.elseClause != null) {
            this.elseClause.getNodePointers(pointers);
        }
    }

    @Override
    public void executeBodyCommand(Map<String, Object> variables, WoolNodeBody processedBody) throws EvaluationException {
        for (Clause clause : this.ifClauses) {
            Value clauseEval = clause.expression.evaluate(variables);
            if (!clauseEval.asBoolean()) continue;
            clause.statement.execute(variables, false, processedBody);
            return;
        }
        if (this.elseClause != null) {
            this.elseClause.execute(variables, false, processedBody);
        }
    }

    public String toString() {
        String newline = System.getProperty("line.separator");
        Clause clause = this.ifClauses.get(0);
        StringBuilder result = new StringBuilder("<<if " + clause.expression + ">>" + newline);
        result.append(clause.statement + newline);
        for (int i = 1; i < this.ifClauses.size(); ++i) {
            clause = this.ifClauses.get(i);
            result.append("<<elseif " + clause.expression + ">>" + newline);
            result.append(clause.statement + newline);
        }
        if (this.elseClause != null) {
            result.append("<<else>>" + newline);
            result.append(this.elseClause + newline);
        }
        result.append("<<endif>>");
        return result.toString();
    }

    public static WoolIfCommand parse(WoolBodyToken cmdStartToken, CurrentIterator<WoolBodyToken> tokens, WoolNodeState nodeState) throws LineNumberParseException {
        WoolIfCommand command = new WoolIfCommand();
        WoolExpressionCommand.ReadContentResult content = WoolIfCommand.readCommandContent(cmdStartToken, tokens);
        WoolExpressionCommand.ParseContentResult parsedIf = WoolIfCommand.parseCommandContentExpression(cmdStartToken, content, "if");
        WoolIfCommand.checkNoAssignment(cmdStartToken, parsedIf.name, parsedIf.expression);
        while (true) {
            WoolBodyParser bodyParser = new WoolBodyParser(nodeState);
            WoolBodyParser.ParseUntilIfClauseResult bodyParse = bodyParser.parseUntilIfClause(tokens, Arrays.asList("action", "if", "set"));
            if (bodyParse.ifClauseStartToken == null) {
                throw new LineNumberParseException("Command \"if\" not terminated", cmdStartToken.getLineNum(), cmdStartToken.getColNum());
            }
            if (parsedIf.name.equals("if") || parsedIf.name.equals("elseif")) {
                command.addIfClause(new Clause(parsedIf.expression, bodyParse.body));
            } else {
                command.setElseClause(bodyParse.body);
            }
            WoolBodyToken clauseStartToken = bodyParse.ifClauseStartToken;
            String clauseName = bodyParse.ifClauseName;
            content = WoolIfCommand.readCommandContent(clauseStartToken, tokens);
            switch (clauseName) {
                case "elseif": {
                    if (command.elseClause != null) {
                        throw new LineNumberParseException("Found \"elseif\" after \"else\"", clauseStartToken.getLineNum(), clauseStartToken.getColNum());
                    }
                    parsedIf = WoolIfCommand.parseCommandContentExpression(clauseStartToken, content, clauseName);
                    WoolIfCommand.checkNoAssignment(clauseStartToken, parsedIf.name, parsedIf.expression);
                    break;
                }
                case "else": {
                    if (command.elseClause != null) {
                        throw new LineNumberParseException("Found more than one \"else\"", clauseStartToken.getLineNum(), clauseStartToken.getColNum());
                    }
                    parsedIf = WoolIfCommand.parseCommandContentName(clauseStartToken, content, clauseName);
                    break;
                }
                case "endif": {
                    WoolIfCommand.parseCommandContentName(clauseStartToken, content, clauseName);
                    return command;
                }
            }
        }
    }

    private static void checkNoAssignment(WoolBodyToken cmdStartToken, String name, Expression expression) throws LineNumberParseException {
        ArrayList<Expression> list = new ArrayList<Expression>();
        list.add(expression);
        list.addAll(expression.getDescendants());
        for (Expression expr : list) {
            if (!(expr instanceof AssignExpression)) continue;
            throw new LineNumberParseException(String.format("Found assignment expression in \"%s\" command", name), cmdStartToken.getLineNum(), cmdStartToken.getColNum());
        }
    }

    public static class Clause {
        private Expression expression;
        private WoolNodeBody statement;

        public Clause(Expression expression, WoolNodeBody statement) {
            this.expression = expression;
            this.statement = statement;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression expression) {
            this.expression = expression;
        }

        public WoolNodeBody getStatement() {
            return this.statement;
        }

        public void setStatement(WoolNodeBody statement) {
            this.statement = statement;
        }
    }
}

