/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.model.command;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.rrd.wool.exception.LineNumberParseException;
import nl.rrd.wool.execution.WoolVariableStore;
import nl.rrd.wool.model.WoolReply;
import nl.rrd.wool.model.command.WoolAttributesCommand;
import nl.rrd.wool.model.command.WoolInputNumericCommand;
import nl.rrd.wool.model.command.WoolInputSetCommand;
import nl.rrd.wool.model.command.WoolInputTextCommand;
import nl.rrd.wool.model.command.WoolInputTimeCommand;
import nl.rrd.wool.model.nodepointer.WoolNodePointer;
import nl.rrd.wool.parser.WoolBodyToken;
import nl.rrd.wool.parser.WoolNodeState;
import nl.rrd.wool.utils.CurrentIterator;

public abstract class WoolInputCommand
extends WoolAttributesCommand {
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_NUMERIC = "numeric";
    public static final String TYPE_SET = "set";
    public static final String TYPE_TIME = "time";
    private static final List<String> VALID_TYPES = Arrays.asList("text", "numeric", "set", "time");
    private String type;

    public WoolInputCommand(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public abstract Map<String, ?> getParameters();

    public abstract String getStatementLog(WoolVariableStore var1);

    @Override
    public WoolReply findReplyById(int replyId) {
        return null;
    }

    @Override
    public void getNodePointers(Set<WoolNodePointer> pointers) {
    }

    public static WoolInputCommand parse(WoolBodyToken cmdStartToken, CurrentIterator<WoolBodyToken> tokens, WoolNodeState nodeState) throws LineNumberParseException {
        Map<String, WoolBodyToken> attrs = WoolInputCommand.parseAttributesCommand(cmdStartToken, tokens);
        String type = WoolInputCommand.readPlainTextAttr("type", attrs, cmdStartToken, true);
        WoolBodyToken token = attrs.get("type");
        if (!VALID_TYPES.contains(type)) {
            throw new LineNumberParseException("Invalid value for attribute \"type\": " + type, token.getLineNum(), token.getColNum());
        }
        switch (type) {
            case "text": {
                return WoolInputTextCommand.parse(cmdStartToken, attrs);
            }
            case "numeric": {
                return WoolInputNumericCommand.parse(cmdStartToken, attrs);
            }
            case "set": {
                return WoolInputSetCommand.parse(cmdStartToken, attrs);
            }
            case "time": {
                return WoolInputTimeCommand.parse(cmdStartToken, attrs);
            }
        }
        throw new RuntimeException("Unsupported value for input type: " + type);
    }
}

