/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.model.command;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import nl.rrd.wool.exception.LineNumberParseException;
import nl.rrd.wool.execution.WoolVariableStore;
import nl.rrd.wool.expressions.EvaluationException;
import nl.rrd.wool.expressions.Value;
import nl.rrd.wool.model.WoolNodeBody;
import nl.rrd.wool.model.WoolVariableString;
import nl.rrd.wool.model.command.WoolInputCommand;
import nl.rrd.wool.parser.WoolBodyToken;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class WoolInputTimeCommand
extends WoolInputCommand {
    public static final String TIME_NOW = "now";
    private String variableName;
    private int granularityMinutes = 1;
    private WoolVariableString startTime = null;
    private WoolVariableString minTime = null;
    private WoolVariableString maxTime = null;

    public WoolInputTimeCommand(String variableName) {
        super("time");
        this.variableName = variableName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public int getGranularityMinutes() {
        return this.granularityMinutes;
    }

    public void setGranularityMinutes(int granularityMinutes) {
        this.granularityMinutes = granularityMinutes;
    }

    public WoolVariableString getStartTime() {
        return this.startTime;
    }

    public void setStartTime(WoolVariableString startTime) {
        this.startTime = startTime;
    }

    public WoolVariableString getMinTime() {
        return this.minTime;
    }

    public void setMinTime(WoolVariableString minTime) {
        this.minTime = minTime;
    }

    public WoolVariableString getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(WoolVariableString maxTime) {
        this.maxTime = maxTime;
    }

    @Override
    public Map<String, ?> getParameters() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("variableName", this.variableName);
        result.put("granularityMinutes", this.granularityMinutes);
        if (this.startTime != null) {
            result.put("startTime", this.startTime.evaluate(null));
        }
        if (this.minTime != null) {
            result.put("minTime", this.minTime.evaluate(null));
        }
        if (this.maxTime != null) {
            result.put("maxTime", this.maxTime.evaluate(null));
        }
        return result;
    }

    @Override
    public String getStatementLog(WoolVariableStore varStore) {
        Value value = new Value(varStore.getValue(this.variableName));
        return value.toString();
    }

    @Override
    public void getReadVariableNames(Set<String> varNames) {
        if (this.startTime != null) {
            this.startTime.getReadVariableNames(varNames);
        }
        if (this.minTime != null) {
            this.minTime.getReadVariableNames(varNames);
        }
        if (this.maxTime != null) {
            this.maxTime.getReadVariableNames(varNames);
        }
    }

    @Override
    public void getWriteVariableNames(Set<String> varNames) {
        varNames.add(this.variableName);
    }

    @Override
    public void executeBodyCommand(Map<String, Object> variables, WoolNodeBody processedBody) throws EvaluationException {
        WoolInputTimeCommand processedCmd = new WoolInputTimeCommand(this.variableName);
        processedCmd.granularityMinutes = this.granularityMinutes;
        if (this.startTime != null) {
            processedCmd.startTime = WoolInputTimeCommand.evaluateTime(this.startTime.evaluate(variables));
        }
        if (this.minTime != null) {
            processedCmd.minTime = WoolInputTimeCommand.evaluateTime(this.minTime.evaluate(variables));
        }
        if (this.maxTime != null) {
            processedCmd.maxTime = WoolInputTimeCommand.evaluateTime(this.maxTime.evaluate(variables));
        }
        processedBody.addSegment(new WoolNodeBody.CommandSegment(processedCmd));
    }

    private static WoolVariableString evaluateTime(String text) throws EvaluationException {
        LocalTime time;
        if (text.toLowerCase().equals(TIME_NOW)) {
            return new WoolVariableString(TIME_NOW);
        }
        DateTimeFormatter parser = ISODateTimeFormat.localTimeParser();
        try {
            time = parser.parseLocalTime(text);
        }
        catch (IllegalArgumentException ex) {
            throw new EvaluationException("Invalid local time value: " + text);
        }
        return new WoolVariableString(time.toString("HH:mm"));
    }

    public String toString() {
        char[] escapes = new char[]{'\"'};
        StringBuilder builder = new StringBuilder("<<input type=\"time\"");
        builder.append(" value=\"$" + this.variableName + "\"");
        builder.append(" granularityMinutes=\"" + this.granularityMinutes + "\"");
        if (this.startTime != null) {
            builder.append(" startTime=\"" + this.startTime.toString(escapes) + "\"");
        }
        if (this.minTime != null) {
            builder.append(" minTime=\"" + this.minTime.toString(escapes) + "\"");
        }
        if (this.maxTime != null) {
            builder.append(" maxTime=\"" + this.maxTime.toString(escapes) + "\"");
        }
        builder.append(">>");
        return builder.toString();
    }

    public static WoolInputTimeCommand parse(WoolBodyToken cmdStartToken, Map<String, WoolBodyToken> attrs) throws LineNumberParseException {
        String variableName = WoolInputTimeCommand.readVariableAttr("value", attrs, cmdStartToken, true);
        WoolInputTimeCommand command = new WoolInputTimeCommand(variableName);
        Integer granularityMinutes = WoolInputTimeCommand.readIntAttr("granularityMinutes", attrs, cmdStartToken, false, 1, null);
        if (granularityMinutes != null) {
            command.granularityMinutes = granularityMinutes;
        }
        command.startTime = WoolInputTimeCommand.readTimeAttribute("startTime", attrs, cmdStartToken);
        command.minTime = WoolInputTimeCommand.readTimeAttribute("minTime", attrs, cmdStartToken);
        command.maxTime = WoolInputTimeCommand.readTimeAttribute("maxTime", attrs, cmdStartToken);
        return command;
    }

    private static WoolVariableString readTimeAttribute(String attrName, Map<String, WoolBodyToken> attrs, WoolBodyToken cmdStartToken) throws LineNumberParseException {
        WoolVariableString result = WoolInputTimeCommand.readAttr(attrName, attrs, cmdStartToken, false);
        if (result == null || !result.isPlainText()) {
            return result;
        }
        WoolBodyToken token = attrs.get(attrName);
        String value = result.evaluate(null);
        try {
            return WoolInputTimeCommand.evaluateTime(value);
        }
        catch (EvaluationException ex) {
            throw new LineNumberParseException(String.format("Invalid value for attribute \"%s\"", attrName) + ": " + ex.getMessage(), token.getLineNum(), token.getColNum(), ex);
        }
    }
}

