/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.parser;

import java.util.ArrayList;
import java.util.List;
import nl.rrd.wool.exception.LineNumberParseException;
import nl.rrd.wool.model.WoolVariableString;
import nl.rrd.wool.parser.WoolBodyToken;
import nl.rrd.wool.utils.ReferenceParameter;

public class WoolBodyTokenizer {
    private BodyState bodyState = new BodyState();

    public List<WoolBodyToken> readBodyTokens(String line, int lineNum) throws LineNumberParseException {
        ArrayList<WoolBodyToken> tokens = new ArrayList<WoolBodyToken>();
        this.startBodyTextBuffer(1);
        StringBuilder specialBuffer = null;
        boolean foundComment = false;
        int i = 0;
        block19: while (!foundComment && i < line.length()) {
            char c = line.charAt(i);
            if (specialBuffer == null) {
                switch (c) {
                    case '$': {
                        i = this.readBodyVariable(tokens, line, lineNum, i);
                        continue block19;
                    }
                    case '/': 
                    case '<': 
                    case '>': 
                    case '\\': {
                        specialBuffer = new StringBuilder();
                        specialBuffer.append(c);
                        ++i;
                        continue block19;
                    }
                    case '[': 
                    case ']': {
                        if (this.bodyState.inCommand) {
                            this.bodyState.textBuffer.append(c);
                        } else {
                            specialBuffer = new StringBuilder();
                            specialBuffer.append(c);
                        }
                        ++i;
                        continue block19;
                    }
                    case '\"': {
                        if (this.bodyState.inCommand) {
                            i = this.readQuotedString(tokens, line, lineNum, i);
                            continue block19;
                        }
                        this.bodyState.textBuffer.append(c);
                        ++i;
                        continue block19;
                    }
                    case '|': {
                        if (this.bodyState.inReply && !this.bodyState.inCommand) {
                            this.finishTextToken(tokens, line, lineNum, i);
                            this.finishReplySeparator(tokens, lineNum, i + 1);
                            this.startBodyTextBuffer(i + 2);
                        } else {
                            this.bodyState.textBuffer.append(c);
                        }
                        ++i;
                        continue block19;
                    }
                }
                this.bodyState.textBuffer.append(c);
                ++i;
                continue;
            }
            char specialStart = specialBuffer.charAt(0);
            switch (specialStart) {
                case '\\': {
                    this.bodyState.textBuffer.append(c);
                    specialBuffer = null;
                    ++i;
                    break;
                }
                case '<': {
                    if (c == '<') {
                        this.finishTextToken(tokens, line, lineNum, i - 1);
                        this.finishCommandStart(tokens, lineNum, i);
                        this.startBodyTextBuffer(i + 2);
                        ++i;
                    } else {
                        this.bodyState.textBuffer.append((CharSequence)specialBuffer);
                    }
                    specialBuffer = null;
                    break;
                }
                case '>': {
                    if (c == '>') {
                        this.finishTextToken(tokens, line, lineNum, i - 1);
                        this.finishCommandEnd(tokens, lineNum, i);
                        this.startBodyTextBuffer(i + 2);
                        ++i;
                    } else {
                        this.bodyState.textBuffer.append((CharSequence)specialBuffer);
                    }
                    specialBuffer = null;
                    break;
                }
                case '[': {
                    if (c == '[') {
                        this.finishTextToken(tokens, line, lineNum, i - 1);
                        this.finishReplyStart(tokens, lineNum, i);
                        this.startBodyTextBuffer(i + 2);
                        ++i;
                    } else {
                        this.bodyState.textBuffer.append((CharSequence)specialBuffer);
                    }
                    specialBuffer = null;
                    break;
                }
                case ']': {
                    if (c == ']') {
                        this.finishTextToken(tokens, line, lineNum, i - 1);
                        this.finishReplyEnd(tokens, lineNum, i);
                        this.startBodyTextBuffer(i + 2);
                        ++i;
                    } else {
                        this.bodyState.textBuffer.append((CharSequence)specialBuffer);
                    }
                    specialBuffer = null;
                    break;
                }
                case '/': {
                    if (c == '/') {
                        foundComment = true;
                    } else {
                        this.bodyState.textBuffer.append((CharSequence)specialBuffer);
                    }
                    specialBuffer = null;
                }
            }
        }
        if (specialBuffer != null) {
            char specialStart = specialBuffer.charAt(0);
            switch (specialStart) {
                case '\\': {
                    break;
                }
                case '/': 
                case '<': 
                case '>': 
                case '[': 
                case ']': {
                    this.bodyState.textBuffer.append(specialStart);
                }
            }
        }
        this.finishTextToken(tokens, line, lineNum, line.length());
        return tokens;
    }

    private int readBodyVariable(List<WoolBodyToken> tokens, String line, int lineNum, int start) {
        ReferenceParameter<Integer> end = new ReferenceParameter<Integer>();
        String varName = this.readVariableName(line, start + 1, end);
        if (varName.length() == 0) {
            this.bodyState.textBuffer.append('$');
            return end.get();
        }
        this.finishTextToken(tokens, line, lineNum, start);
        WoolBodyToken token = new WoolBodyToken();
        token.setType(WoolBodyToken.Type.VARIABLE);
        token.setText(line.substring(start, end.get()));
        token.setValue(varName);
        token.setLineNum(lineNum);
        token.setColNum(start + 1);
        tokens.add(token);
        this.startBodyTextBuffer(end.get() + 1);
        return end.get();
    }

    private String readVariableName(String line, int start, ReferenceParameter<Integer> end) {
        for (int i = start; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (!(i != start || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_')) {
                end.set(i);
                return "";
            }
            if (i <= start || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_') continue;
            end.set(i);
            return line.substring(start, i);
        }
        end.set(line.length());
        return line.substring(start);
    }

    private int readQuotedString(List<WoolBodyToken> tokens, String line, int lineNum, int start) throws LineNumberParseException {
        this.finishTextToken(tokens, line, lineNum, start);
        ReferenceParameter<Integer> end = new ReferenceParameter<Integer>();
        WoolVariableString string = this.readQuotedString(line, lineNum, start, end);
        WoolBodyToken token = new WoolBodyToken();
        token.setType(WoolBodyToken.Type.QUOTED_STRING);
        token.setLineNum(lineNum);
        token.setColNum(start + 1);
        token.setText(line.substring(start, end.get()));
        token.setValue(string);
        tokens.add(token);
        this.startBodyTextBuffer(end.get() + 1);
        return end.get();
    }

    private WoolVariableString readQuotedString(String line, int lineNum, int start, ReferenceParameter<Integer> end) throws LineNumberParseException {
        WoolVariableString result = new WoolVariableString();
        StringBuilder textBuffer = new StringBuilder();
        int textStart = start + 1;
        boolean prevEscape = false;
        int i = start + 1;
        block5: while (i < line.length()) {
            if (prevEscape) {
                prevEscape = false;
                ++i;
                continue;
            }
            char c = line.charAt(i);
            switch (c) {
                case '\\': {
                    textBuffer.append(line, textStart, i);
                    textStart = i + 1;
                    prevEscape = true;
                    ++i;
                    continue block5;
                }
                case '$': {
                    ReferenceParameter<Integer> varEnd = new ReferenceParameter<Integer>();
                    String varName = this.readVariableName(line, i + 1, varEnd);
                    if (varName.length() > 0) {
                        textBuffer.append(line, textStart, i);
                        if (textBuffer.length() > 0) {
                            result.addSegment(new WoolVariableString.TextSegment(textBuffer.toString()));
                        }
                        result.addSegment(new WoolVariableString.VariableSegment(varName));
                        textBuffer = new StringBuilder();
                        i = textStart = varEnd.get().intValue();
                        continue block5;
                    }
                    ++i;
                    continue block5;
                }
                case '\"': {
                    textBuffer.append(line, textStart, i);
                    if (textBuffer.length() > 0) {
                        result.addSegment(new WoolVariableString.TextSegment(textBuffer.toString()));
                    }
                    end.set(i + 1);
                    return result;
                }
            }
            ++i;
        }
        throw new LineNumberParseException("Quoted string not terminated", lineNum, start + 1);
    }

    private void startBodyTextBuffer(int colNum) {
        this.bodyState.textBuffer = new StringBuilder();
        this.bodyState.textStartCol = colNum;
    }

    private void finishTextToken(List<WoolBodyToken> tokens, String line, int lineNum, int end) {
        String text = this.bodyState.textBuffer.toString();
        if (text.length() == 0) {
            return;
        }
        WoolBodyToken token = new WoolBodyToken();
        token.setType(WoolBodyToken.Type.TEXT);
        token.setText(line.substring(this.bodyState.textStartCol - 1, end));
        token.setValue(text);
        token.setLineNum(lineNum);
        token.setColNum(this.bodyState.textStartCol);
        tokens.add(token);
    }

    private void finishCommandStart(List<WoolBodyToken> tokens, int lineNum, int colNum) throws LineNumberParseException {
        if (this.bodyState.inCommand) {
            throw new LineNumberParseException("Found << inside <<...>>", lineNum, colNum);
        }
        WoolBodyToken token = new WoolBodyToken();
        token.setType(WoolBodyToken.Type.COMMAND_START);
        token.setText("<<");
        token.setLineNum(lineNum);
        token.setColNum(colNum);
        tokens.add(token);
        this.bodyState.inCommand = true;
    }

    private void finishCommandEnd(List<WoolBodyToken> tokens, int lineNum, int colNum) throws LineNumberParseException {
        if (!this.bodyState.inCommand) {
            throw new LineNumberParseException("Found >> without preceding <<", lineNum, colNum);
        }
        WoolBodyToken token = new WoolBodyToken();
        token.setType(WoolBodyToken.Type.COMMAND_END);
        token.setText(">>");
        token.setLineNum(lineNum);
        token.setColNum(colNum);
        tokens.add(token);
        this.bodyState.inCommand = false;
    }

    private void finishReplyStart(List<WoolBodyToken> tokens, int lineNum, int colNum) throws LineNumberParseException {
        if (this.bodyState.inReply) {
            throw new LineNumberParseException("Found [[ inside [[...]]", lineNum, colNum);
        }
        WoolBodyToken token = new WoolBodyToken();
        token.setType(WoolBodyToken.Type.REPLY_START);
        token.setText("[[");
        token.setLineNum(lineNum);
        token.setColNum(colNum);
        tokens.add(token);
        this.bodyState.inReply = true;
    }

    private void finishReplyEnd(List<WoolBodyToken> tokens, int lineNum, int colNum) throws LineNumberParseException {
        if (!this.bodyState.inReply) {
            throw new LineNumberParseException("Found ]] without preceding [[", lineNum, colNum);
        }
        WoolBodyToken token = new WoolBodyToken();
        token.setType(WoolBodyToken.Type.REPLY_END);
        token.setText("]]");
        token.setLineNum(lineNum);
        token.setColNum(colNum);
        tokens.add(token);
        this.bodyState.inReply = false;
    }

    private void finishReplySeparator(List<WoolBodyToken> tokens, int lineNum, int colNum) {
        WoolBodyToken token = new WoolBodyToken();
        token.setType(WoolBodyToken.Type.REPLY_SEPARATOR);
        token.setText("|");
        token.setLineNum(lineNum);
        token.setColNum(colNum);
        tokens.add(token);
    }

    private static class BodyState {
        private boolean inCommand = false;
        private boolean inReply = false;
        private StringBuilder textBuffer;
        private int textStartCol;

        private BodyState() {
        }
    }
}

