/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.rrd.wool.exception.LineNumberParseException;
import nl.rrd.wool.model.WoolNodeBody;
import nl.rrd.wool.model.WoolReply;
import nl.rrd.wool.model.nodepointer.WoolNodePointer;
import nl.rrd.wool.model.nodepointer.WoolNodePointerExternal;
import nl.rrd.wool.model.nodepointer.WoolNodePointerInternal;
import nl.rrd.wool.parser.WoolBodyParser;
import nl.rrd.wool.parser.WoolBodyToken;
import nl.rrd.wool.parser.WoolCommandParser;
import nl.rrd.wool.parser.WoolNodeState;
import nl.rrd.wool.utils.CurrentIterator;

public class WoolReplyParser {
    private WoolNodeState nodeState;
    private ReplySection statementSection;
    private ReplySection nodePointerSection;
    private ReplySection commandSection;

    public WoolReplyParser(WoolNodeState nodeState) {
        this.nodeState = nodeState;
    }

    public WoolReply parse(CurrentIterator<WoolBodyToken> tokens) throws LineNumberParseException {
        this.readSections(tokens);
        WoolNodeBody statement = this.parseStatement();
        WoolNodePointer nodePointer = this.parseNodePointer();
        WoolReply reply = new WoolReply(this.nodeState.createNextReplyId(), statement, nodePointer);
        if (this.commandSection != null) {
            this.parseCommands(reply);
        }
        return reply;
    }

    private void readSections(CurrentIterator<WoolBodyToken> tokens) throws LineNumberParseException {
        int maxSections = 3;
        WoolBodyToken startToken = tokens.getCurrent();
        tokens.moveNext();
        ArrayList<ReplySection> sections = new ArrayList<ReplySection>();
        ReplySection currSection = new ReplySection();
        sections.add(currSection);
        boolean foundEnd = false;
        while (!foundEnd && tokens.getCurrent() != null) {
            WoolBodyToken token = tokens.getCurrent();
            switch (token.getType()) {
                case REPLY_SEPARATOR: {
                    if (sections.size() == maxSections) {
                        throw new LineNumberParseException(String.format("Exceeded maximum number of %s sections", maxSections), token.getLineNum(), token.getColNum());
                    }
                    currSection.endLineNum = token.getLineNum();
                    currSection.endColNum = token.getColNum();
                    currSection = new ReplySection();
                    sections.add(currSection);
                    break;
                }
                case REPLY_END: {
                    currSection.endLineNum = token.getLineNum();
                    currSection.endColNum = token.getColNum();
                    foundEnd = true;
                    break;
                }
                default: {
                    currSection.tokens.add(token);
                }
            }
            tokens.moveNext();
        }
        if (!foundEnd) {
            throw new LineNumberParseException("Reply not terminated", startToken.getLineNum(), startToken.getColNum());
        }
        this.statementSection = null;
        this.nodePointerSection = null;
        this.commandSection = null;
        if (sections.size() == 1) {
            this.nodePointerSection = (ReplySection)sections.get(0);
        } else if (sections.size() == 2) {
            this.statementSection = (ReplySection)sections.get(0);
            this.nodePointerSection = (ReplySection)sections.get(1);
        } else {
            this.statementSection = (ReplySection)sections.get(0);
            this.nodePointerSection = (ReplySection)sections.get(1);
            this.commandSection = (ReplySection)sections.get(2);
        }
    }

    private WoolNodeBody parseStatement() throws LineNumberParseException {
        if (this.statementSection == null) {
            return null;
        }
        WoolBodyParser bodyParser = new WoolBodyParser(this.nodeState);
        WoolNodeBody result = bodyParser.parse(this.statementSection.tokens, Arrays.asList("input"));
        if (result.getSegments().isEmpty()) {
            return null;
        }
        return result;
    }

    private WoolNodePointer parseNodePointer() throws LineNumberParseException {
        WoolBodyToken.trimWhitespace(this.nodePointerSection.tokens);
        if (this.nodePointerSection.tokens.size() == 0) {
            throw new LineNumberParseException("Empty node pointer in reply", this.nodePointerSection.endLineNum, this.nodePointerSection.endColNum);
        }
        WoolBodyToken nodePointerToken = (WoolBodyToken)this.nodePointerSection.tokens.get(0);
        if (this.nodePointerSection.tokens.size() != 1 || nodePointerToken.getType() != WoolBodyToken.Type.TEXT) {
            throw new LineNumberParseException("Invalid node pointer in reply", nodePointerToken.getLineNum(), nodePointerToken.getColNum());
        }
        String nodePointerStr = (String)nodePointerToken.getValue();
        if (!nodePointerStr.matches("[A-Za-z0-9_-]+(\\.[A-Za-z0-9_-]+)?")) {
            throw new LineNumberParseException("Invalid node pointer in reply: " + nodePointerStr, nodePointerToken.getLineNum(), nodePointerToken.getColNum());
        }
        int sep = nodePointerStr.indexOf(46);
        WoolNodePointer result = sep == -1 ? new WoolNodePointerInternal(nodePointerStr) : new WoolNodePointerExternal(nodePointerStr.substring(0, sep), nodePointerStr.substring(sep + 1));
        this.nodeState.addNodePointerToken(result, nodePointerToken);
        return result;
    }

    private void parseCommands(WoolReply reply) throws LineNumberParseException {
        CurrentIterator<WoolBodyToken> it = new CurrentIterator<WoolBodyToken>(this.commandSection.tokens.iterator());
        it.moveNext();
        WoolBodyToken.skipWhitespace(it);
        while (it.getCurrent() != null) {
            WoolBodyToken token = it.getCurrent();
            if (token.getType() != WoolBodyToken.Type.COMMAND_START) {
                throw new LineNumberParseException("Expected <<, found token: " + (Object)((Object)token.getType()), token.getLineNum(), token.getColNum());
            }
            WoolCommandParser cmdParser = new WoolCommandParser(Arrays.asList("action", "set"), this.nodeState);
            reply.addCommand(cmdParser.parseFromStart(it));
            WoolBodyToken.skipWhitespace(it);
        }
    }

    private class ReplySection {
        private List<WoolBodyToken> tokens = new ArrayList<WoolBodyToken>();
        private int endLineNum;
        private int endColNum;

        private ReplySection() {
        }
    }
}

