/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.execution;

import java.util.List;
import java.util.Map;
import nl.rrd.wool.exception.WoolException;
import nl.rrd.wool.execution.DialogueState;
import nl.rrd.wool.execution.WoolVariableStore;
import nl.rrd.wool.expressions.EvaluationException;
import nl.rrd.wool.model.WoolDialogue;
import nl.rrd.wool.model.WoolDialogueDescription;
import nl.rrd.wool.model.WoolNode;
import nl.rrd.wool.model.WoolNodeBody;
import nl.rrd.wool.model.WoolReply;
import nl.rrd.wool.model.command.WoolCommand;
import nl.rrd.wool.model.command.WoolInputCommand;
import nl.rrd.wool.model.command.WoolSetCommand;
import nl.rrd.wool.model.nodepointer.WoolNodePointer;
import nl.rrd.wool.model.nodepointer.WoolNodePointerInternal;
import org.joda.time.DateTime;

public class ActiveWoolDialogue {
    private WoolDialogueDescription dialogueDescription;
    private WoolDialogue dialogueDefinition;
    private WoolNode currentNode;
    private DialogueState dialogueState;
    private WoolVariableStore woolVariableStore;

    public ActiveWoolDialogue(WoolDialogueDescription dialogueDescription, WoolDialogue dialogueDefinition) {
        this.dialogueDescription = dialogueDescription;
        this.dialogueDefinition = dialogueDefinition;
        this.dialogueState = DialogueState.INACTIVE;
    }

    public WoolDialogueDescription getDialogueDescription() {
        return this.dialogueDescription;
    }

    public WoolDialogue getDialogueDefinition() {
        return this.dialogueDefinition;
    }

    public WoolNode getCurrentNode() {
        return this.currentNode;
    }

    public DialogueState getDialogueState() {
        return this.dialogueState;
    }

    public WoolVariableStore getWoolVariableStore() {
        return this.woolVariableStore;
    }

    public void setCurrentNode(WoolNode currentNode) {
        this.currentNode = currentNode;
    }

    public void setDialogueState(DialogueState dialogueState) {
        this.dialogueState = dialogueState;
    }

    public void setWoolVariableStore(WoolVariableStore woolVariableStore) {
        this.woolVariableStore = woolVariableStore;
    }

    public String getDialogueName() {
        return this.dialogueDefinition.getDialogueName();
    }

    public WoolNode startDialogue(DateTime time) throws WoolException, EvaluationException {
        return this.startDialogue(null, time);
    }

    public WoolNode startDialogue(String nodeId, DateTime time) throws WoolException, EvaluationException {
        WoolNode nextNode;
        this.dialogueState = DialogueState.ACTIVE;
        if (nodeId == null) {
            nextNode = this.dialogueDefinition.getStartNode();
        } else {
            nextNode = this.dialogueDefinition.getNodeById(nodeId);
            if (nextNode == null) {
                throw new WoolException(WoolException.Type.NODE_NOT_FOUND, String.format("Node \"%s\" not found in dialogue \"%s\"", nodeId, this.dialogueDefinition.getDialogueName()));
            }
        }
        this.currentNode = this.executeWoolNode(nextNode, time);
        if (this.currentNode.getBody().getReplies().size() == 0) {
            this.dialogueState = DialogueState.FINISHED;
        }
        return this.currentNode;
    }

    public WoolNodePointer processReplyAndGetNodePointer(int replyId, DateTime time) throws EvaluationException {
        WoolReply selectedWoolReply = this.currentNode.getBody().findReplyById(replyId);
        Map<String, Object> variableMap = this.woolVariableStore.getModifiableMap(true, time);
        for (WoolCommand command : selectedWoolReply.getCommands()) {
            if (!(command instanceof WoolSetCommand)) continue;
            WoolSetCommand setCommand = (WoolSetCommand)command;
            setCommand.getExpression().evaluate(variableMap);
        }
        return selectedWoolReply.getNodePointer();
    }

    public WoolNode progressDialogue(WoolNodePointerInternal nodePointer, DateTime time) throws EvaluationException {
        WoolNode nextNode = null;
        if (!nodePointer.getNodeId().toLowerCase().equals("end")) {
            nextNode = this.dialogueDefinition.getNodeById(nodePointer.getNodeId());
        }
        this.currentNode = nextNode;
        if (nextNode == null || nextNode.getBody().getReplies().isEmpty()) {
            this.dialogueState = DialogueState.FINISHED;
        }
        if (nextNode != null) {
            this.currentNode = this.executeWoolNode(nextNode, time);
        }
        return this.currentNode;
    }

    public void storeReplyInput(Map<String, ?> variables, DateTime time) {
        Map<String, Object> map = this.woolVariableStore.getModifiableMap(true, time);
        map.putAll(variables);
    }

    public String getUserStatementFromReplyId(int replyId) throws WoolException {
        WoolReply selectedReply = this.currentNode.getBody().findReplyById(replyId);
        if (selectedReply == null) {
            throw new WoolException(WoolException.Type.REPLY_NOT_FOUND, String.format("Reply with ID %s not found in dialogue \"%s\", node \"%s\"", replyId, this.dialogueDefinition.getDialogueName(), this.currentNode.getTitle()));
        }
        if (selectedReply.getStatement() == null) {
            return "AUTOFORWARD";
        }
        StringBuilder result = new StringBuilder();
        List<WoolNodeBody.Segment> segments = selectedReply.getStatement().getSegments();
        for (WoolNodeBody.Segment segment : segments) {
            if (segment instanceof WoolNodeBody.TextSegment) {
                WoolNodeBody.TextSegment textSegment = (WoolNodeBody.TextSegment)segment;
                result.append(textSegment.getText().evaluate(null));
                continue;
            }
            WoolNodeBody.CommandSegment cmdSegment = (WoolNodeBody.CommandSegment)segment;
            WoolInputCommand command = (WoolInputCommand)cmdSegment.getCommand();
            result.append(command.getStatementLog(this.woolVariableStore));
        }
        return result.toString();
    }

    private WoolNode executeWoolNode(WoolNode woolNode, DateTime time) throws EvaluationException {
        WoolNode processedNode = new WoolNode();
        processedNode.setHeader(woolNode.getHeader());
        WoolNodeBody processedBody = new WoolNodeBody();
        Map<String, Object> variables = this.woolVariableStore.getModifiableMap(true, time);
        woolNode.getBody().execute(variables, true, processedBody);
        processedNode.setBody(processedBody);
        return processedNode;
    }
}

