/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.execution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.rrd.wool.execution.WoolVariableStoreChange;
import org.joda.time.DateTime;

public class WoolVariableStore {
    private Map<String, Object> variableMap = new HashMap<String, Object>();
    private final List<OnChangeListener> onChangeListeners = new ArrayList<OnChangeListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnChangeListener(OnChangeListener listener) {
        List<OnChangeListener> list = this.onChangeListeners;
        synchronized (list) {
            this.onChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnChangeListener(OnChangeListener listener) {
        List<OnChangeListener> list = this.onChangeListeners;
        synchronized (list) {
            this.onChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOnChange(WoolVariableStoreChange ... changes) {
        ArrayList<OnChangeListener> ls;
        List<OnChangeListener> list = this.onChangeListeners;
        synchronized (list) {
            ls = new ArrayList<OnChangeListener>(this.onChangeListeners);
        }
        for (OnChangeListener l : ls) {
            l.onChange(this, Arrays.asList(changes));
        }
    }

    public void setValue(String name, Object value, boolean save, DateTime time) {
        this.variableMap.put(name, value);
        if (save) {
            this.notifyOnChange(new WoolVariableStoreChange.Put(name, value, time));
        }
    }

    public Object getValue(String name) {
        return this.variableMap.get(name);
    }

    public Map<String, Object> getModifiableMap(boolean save, DateTime time) {
        return new SourceMap(save, time);
    }

    public static interface OnChangeListener {
        public void onChange(WoolVariableStore var1, List<WoolVariableStoreChange> var2);
    }

    private class SourceMap
    implements Map<String, Object> {
        private boolean save;
        private DateTime time;

        public SourceMap(boolean save, DateTime time) {
            this.save = save;
            this.time = time;
        }

        @Override
        public int size() {
            return WoolVariableStore.this.variableMap.size();
        }

        @Override
        public boolean isEmpty() {
            return WoolVariableStore.this.variableMap.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return WoolVariableStore.this.variableMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return WoolVariableStore.this.variableMap.containsValue(value);
        }

        @Override
        public Object get(Object key) {
            return WoolVariableStore.this.variableMap.get(key);
        }

        @Override
        public Object put(String key, Object value) {
            Object result = this.get(key);
            WoolVariableStore.this.setValue(key, value, this.save, this.time);
            return result;
        }

        @Override
        public Object remove(Object key) {
            Object result = WoolVariableStore.this.variableMap.remove(key);
            if (this.save) {
                WoolVariableStore.this.notifyOnChange(new WoolVariableStoreChange[]{new WoolVariableStoreChange.Remove((String)key, this.time)});
            }
            return result;
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            WoolVariableStore.this.variableMap.putAll(m);
            if (this.save) {
                LinkedHashMap notifyMap = new LinkedHashMap(m);
                WoolVariableStore.this.notifyOnChange(new WoolVariableStoreChange[]{new WoolVariableStoreChange.Put(notifyMap, this.time)});
            }
        }

        @Override
        public void clear() {
            WoolVariableStore.this.variableMap.clear();
            if (this.save) {
                WoolVariableStore.this.notifyOnChange(new WoolVariableStoreChange[]{new WoolVariableStoreChange.Clear(this.time)});
            }
        }

        @Override
        public Set<String> keySet() {
            return WoolVariableStore.this.variableMap.keySet();
        }

        @Override
        public Collection<Object> values() {
            return WoolVariableStore.this.variableMap.values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return WoolVariableStore.this.variableMap.entrySet();
        }
    }
}

