/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.execution;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.joda.time.DateTime;

public abstract class WoolVariableStoreChange {

    public static class Clear
    extends WoolVariableStoreChange {
        private DateTime time;

        public Clear(DateTime time) {
            this.time = time;
        }

        public DateTime getTime() {
            return this.time;
        }
    }

    public static class Remove
    extends WoolVariableStoreChange {
        private Collection<String> variableNames;
        private DateTime time;

        public Remove(Collection<String> variableNames, DateTime time) {
            this.variableNames = variableNames;
            this.time = time;
        }

        public Remove(String variableName, DateTime time) {
            this.variableNames = Collections.singletonList(variableName);
            this.time = time;
        }

        public Collection<String> getVariableNames() {
            return this.variableNames;
        }

        public DateTime getTime() {
            return this.time;
        }
    }

    public static class Put
    extends WoolVariableStoreChange {
        private Map<String, ?> variables;
        private DateTime time;

        public Put(Map<String, ?> variables, DateTime time) {
            this.variables = variables;
            this.time = time;
        }

        public Put(String name, Object value, DateTime time) {
            LinkedHashMap variables = new LinkedHashMap();
            variables.put(name, value);
            this.variables = variables;
            this.time = time;
        }

        public Map<String, ?> getVariables() {
            return this.variables;
        }

        public DateTime getTime() {
            return this.time;
        }
    }
}

