/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.expressions;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import nl.rrd.wool.exception.LineNumberParseException;
import nl.rrd.wool.exception.ParseException;
import nl.rrd.wool.expressions.EvaluationException;
import nl.rrd.wool.expressions.Expression;
import nl.rrd.wool.expressions.ExpressionParserConfig;
import nl.rrd.wool.expressions.StringExpression;
import nl.rrd.wool.expressions.Token;
import nl.rrd.wool.expressions.Tokenizer;
import nl.rrd.wool.expressions.Value;
import nl.rrd.wool.expressions.types.AddExpression;
import nl.rrd.wool.expressions.types.AndExpression;
import nl.rrd.wool.expressions.types.AssignExpression;
import nl.rrd.wool.expressions.types.DivideExpression;
import nl.rrd.wool.expressions.types.DotExpression;
import nl.rrd.wool.expressions.types.EqualExpression;
import nl.rrd.wool.expressions.types.GreaterEqualExpression;
import nl.rrd.wool.expressions.types.GreaterThanExpression;
import nl.rrd.wool.expressions.types.GroupExpression;
import nl.rrd.wool.expressions.types.InExpression;
import nl.rrd.wool.expressions.types.IndexExpression;
import nl.rrd.wool.expressions.types.LessEqualExpression;
import nl.rrd.wool.expressions.types.LessThanExpression;
import nl.rrd.wool.expressions.types.ListExpression;
import nl.rrd.wool.expressions.types.MultiplyExpression;
import nl.rrd.wool.expressions.types.NotEqualExpression;
import nl.rrd.wool.expressions.types.NotExpression;
import nl.rrd.wool.expressions.types.NotStrictEqualExpression;
import nl.rrd.wool.expressions.types.ObjectExpression;
import nl.rrd.wool.expressions.types.OrExpression;
import nl.rrd.wool.expressions.types.StrictEqualExpression;
import nl.rrd.wool.expressions.types.SubtractExpression;
import nl.rrd.wool.expressions.types.ValueExpression;
import nl.rrd.wool.io.LineColumnNumberReader;

public class ExpressionParser {
    private ExpressionParserConfig config = new ExpressionParserConfig();
    private LineColumnNumberReader reader;
    private Tokenizer tokenizer;
    private Object lookAheadState = null;
    public static final Token.Type[][] PRECEDENCE = new Token.Type[][]{{Token.Type.ASSIGN}, {Token.Type.OR}, {Token.Type.AND}, {Token.Type.IN}, {Token.Type.EQUAL, Token.Type.NOT_EQUAL, Token.Type.STRICT_EQUAL, Token.Type.NOT_STRICT_EQUAL}, {Token.Type.LESS_THAN, Token.Type.LESS_EQUAL, Token.Type.GREATER_EQUAL, Token.Type.GREATER_THAN}, {Token.Type.ADD, Token.Type.SUBTRACT}, {Token.Type.MULTIPLY, Token.Type.DIVIDE}};

    public ExpressionParser(String input) {
        this(new StringReader(input));
    }

    public ExpressionParser(Reader reader) {
        this(new LineColumnNumberReader(reader));
    }

    public ExpressionParser(LineColumnNumberReader reader) {
        this(new Tokenizer(reader));
    }

    public ExpressionParser(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
        this.reader = tokenizer.getReader();
    }

    public void close() throws IOException {
        this.tokenizer.close();
    }

    public ExpressionParserConfig getConfig() {
        return this.config;
    }

    public void setConfig(ExpressionParserConfig config) {
        this.config = config;
    }

    public Expression readExpression() throws LineNumberParseException, IOException {
        if (this.lookAheadState != null) {
            this.reader.clearRestoreState(this.lookAheadState);
        }
        this.lookAheadState = this.reader.getRestoreState();
        return this.doReadExpression(false);
    }

    public Expression readOperand() throws LineNumberParseException, IOException {
        if (this.lookAheadState != null) {
            this.reader.clearRestoreState(this.lookAheadState);
        }
        this.lookAheadState = this.reader.getRestoreState();
        return this.doReadOperand(false);
    }

    public int getLineNum() {
        return this.reader.getLineNum();
    }

    public int getColNum() {
        return this.reader.getColNum();
    }

    public void rewind() throws IOException {
        if (this.lookAheadState == null) {
            throw new IOException("Rewind can only be executed once after read");
        }
        this.reader.restoreState(this.lookAheadState);
        this.lookAheadState = null;
    }

    private Expression doReadExpression(boolean require) throws LineNumberParseException, IOException {
        ArrayList<ExpressionElement> elements;
        Object lastCompleteState;
        block16: {
            Token token = this.tokenizer.readToken();
            if (token == null) {
                if (!require) {
                    return null;
                }
                throw this.createParseException("Unexpected end of expression", this.tokenizer.getLineNum(), this.tokenizer.getColNum());
            }
            lastCompleteState = null;
            elements = new ArrayList<ExpressionElement>();
            Expression afterOperand = null;
            boolean foundEnd = false;
            try {
                while (token != null && !foundEnd) {
                    if (afterOperand == null) {
                        this.tokenizer.rewind();
                        afterOperand = this.doReadOperand(true);
                        if (lastCompleteState != null) {
                            this.reader.clearRestoreState(lastCompleteState);
                        }
                        lastCompleteState = this.reader.getRestoreState();
                        elements.add(new ExpressionElement(afterOperand));
                        token = this.tokenizer.readToken();
                        if (token == null) break;
                    }
                    switch (token.getType()) {
                        case ASSIGN: 
                        case OR: 
                        case AND: 
                        case IN: 
                        case LESS_THAN: 
                        case LESS_EQUAL: 
                        case EQUAL: 
                        case NOT_EQUAL: 
                        case STRICT_EQUAL: 
                        case NOT_STRICT_EQUAL: 
                        case GREATER_EQUAL: 
                        case GREATER_THAN: 
                        case ADD: 
                        case SUBTRACT: 
                        case MULTIPLY: 
                        case DIVIDE: {
                            elements.add(new ExpressionElement(token));
                            afterOperand = null;
                            token = this.tokenizer.readToken();
                            break;
                        }
                        case DOT: 
                        case BRACKET_OPEN: {
                            this.tokenizer.rewind();
                            afterOperand = this.readPostfixOperator(token.getType(), afterOperand);
                            elements.remove(elements.size() - 1);
                            elements.add(new ExpressionElement(afterOperand));
                            if (lastCompleteState != null) {
                                this.reader.clearRestoreState(lastCompleteState);
                            }
                            lastCompleteState = this.reader.getRestoreState();
                            token = this.tokenizer.readToken();
                            break;
                        }
                        case NOT: 
                        case BRACKET_CLOSE: 
                        case PARENTHESIS_OPEN: 
                        case PARENTHESIS_CLOSE: 
                        case BRACE_OPEN: 
                        case BRACE_CLOSE: 
                        case COMMA: 
                        case COLON: 
                        case STRING: 
                        case BOOLEAN: 
                        case NUMBER: 
                        case NULL: 
                        case NAME: 
                        case DOLLAR_VARIABLE: {
                            foundEnd = true;
                        }
                    }
                }
            }
            catch (LineNumberParseException ex) {
                if (lastCompleteState != null) break block16;
                throw ex;
            }
        }
        if (lastCompleteState != null) {
            this.reader.restoreState(lastCompleteState);
        }
        ExpressionElement lastElem = (ExpressionElement)elements.get(elements.size() - 1);
        if (lastElem.operand == null) {
            elements.remove(elements.size() - 1);
        }
        return this.mergeExpressionElements(elements, 0, elements.size());
    }

    private Expression mergeExpressionElements(List<ExpressionElement> elements, int start, int end) throws LineNumberParseException {
        if (end - start == 1) {
            return elements.get((int)start).operand;
        }
        for (Token.Type[] level : PRECEDENCE) {
            int op1 = this.findOperator(elements, start, end, level);
            if (op1 == -1) continue;
            Expression merged = null;
            while (op1 != -1) {
                Token operator = elements.get((int)op1).operator;
                int op2 = this.findOperator(elements, op1 + 1, end, level);
                Expression operand1 = merged != null ? merged : this.mergeExpressionElements(elements, start, op1);
                Expression operand2 = this.mergeExpressionElements(elements, op1 + 1, op2 == -1 ? end : op2);
                merged = this.createOperatorExpression(operator, operand1, operand2);
                op1 = op2;
            }
            return merged;
        }
        throw new RuntimeException("No operator found");
    }

    private int findOperator(List<ExpressionElement> elements, int start, int end, Token.Type ... types) {
        for (int i = start + 1; i < end; i += 2) {
            ExpressionElement elem = elements.get(i);
            for (Token.Type type : types) {
                if (elem.operator.getType() != type) continue;
                return i;
            }
        }
        return -1;
    }

    private Expression createOperatorExpression(Token operator, Expression operand1, Expression operand2) throws LineNumberParseException {
        switch (operator.getType()) {
            case ASSIGN: {
                return new AssignExpression(operand1, operator, operand2);
            }
            case OR: {
                return new OrExpression(operand1, operand2);
            }
            case AND: {
                return new AndExpression(operand1, operand2);
            }
            case IN: {
                return new InExpression(operand1, operand2);
            }
            case LESS_THAN: {
                return new LessThanExpression(operand1, operand2);
            }
            case LESS_EQUAL: {
                return new LessEqualExpression(operand1, operand2);
            }
            case EQUAL: {
                return new EqualExpression(operand1, operand2);
            }
            case NOT_EQUAL: {
                return new NotEqualExpression(operand1, operand2);
            }
            case STRICT_EQUAL: {
                return new StrictEqualExpression(operand1, operand2);
            }
            case NOT_STRICT_EQUAL: {
                return new NotStrictEqualExpression(operand1, operand2);
            }
            case GREATER_EQUAL: {
                return new GreaterEqualExpression(operand1, operand2);
            }
            case GREATER_THAN: {
                return new GreaterThanExpression(operand1, operand2);
            }
            case ADD: {
                return new AddExpression(operand1, operand2);
            }
            case SUBTRACT: {
                return new SubtractExpression(operand1, operand2);
            }
            case MULTIPLY: {
                return new MultiplyExpression(operand1, operand2);
            }
            case DIVIDE: {
                return new DivideExpression(operand1, operand2);
            }
        }
        throw new RuntimeException("Unknown operator");
    }

    private Expression doReadOperand(boolean require) throws LineNumberParseException, IOException {
        return this.doReadOperand(require, false);
    }

    private Expression doReadOperand(boolean require, boolean overrideAllowName) throws LineNumberParseException, IOException {
        Token token = this.tokenizer.readToken();
        if (token == null) {
            if (!require) {
                return null;
            }
            throw this.createParseException("Unexpected end of expression", this.tokenizer.getLineNum(), this.tokenizer.getColNum());
        }
        switch (token.getType()) {
            case ASSIGN: 
            case OR: 
            case AND: 
            case IN: 
            case LESS_THAN: 
            case LESS_EQUAL: 
            case EQUAL: 
            case NOT_EQUAL: 
            case STRICT_EQUAL: 
            case NOT_STRICT_EQUAL: 
            case GREATER_EQUAL: 
            case GREATER_THAN: 
            case ADD: 
            case MULTIPLY: 
            case DIVIDE: 
            case DOT: 
            case BRACKET_CLOSE: 
            case PARENTHESIS_CLOSE: 
            case BRACE_CLOSE: 
            case COMMA: 
            case COLON: {
                throw this.createParseException("Invalid token at start of expression: " + token.getText(), token);
            }
            case NOT: {
                this.tokenizer.rewind();
                return this.readNot();
            }
            case SUBTRACT: {
                this.tokenizer.rewind();
                return this.readNegativeNumber();
            }
            case BRACKET_OPEN: {
                this.tokenizer.rewind();
                return this.readList();
            }
            case PARENTHESIS_OPEN: {
                this.tokenizer.rewind();
                return this.readGroup();
            }
            case BRACE_OPEN: {
                this.tokenizer.rewind();
                return this.readObject();
            }
            case STRING: {
                try {
                    return new StringExpression(token.getValue().toString());
                }
                catch (ParseException ex) {
                    throw new LineNumberParseException("Invalid expression in string: " + token.getText() + ": " + ex.getMessage(), token.getLineNum(), token.getColNum(), ex);
                }
            }
            case BOOLEAN: 
            case NUMBER: 
            case NULL: {
                return new ValueExpression(token);
            }
            case NAME: {
                if (overrideAllowName || this.config.isAllowPlainVariables()) {
                    return new ValueExpression(token);
                }
                throw this.createParseException("Variable token without $ not allowed: " + token.getText(), token);
            }
            case DOLLAR_VARIABLE: {
                if (this.config.isAllowDollarVariables()) {
                    return new ValueExpression(token);
                }
                throw this.createParseException("Variable token with $ not allowed: " + token.getText(), token);
            }
        }
        throw new RuntimeException("Unknown token type: " + (Object)((Object)token.getType()));
    }

    private Expression readNot() throws LineNumberParseException, IOException {
        Token token = this.tokenizer.readToken();
        if (token == null) {
            throw this.createParseException("Expected '!', found end of expression", this.tokenizer.getLineNum(), this.tokenizer.getColNum());
        }
        if (token.getType() != Token.Type.NOT) {
            throw this.createParseException("Expected '!', found: " + token.getText(), token);
        }
        Expression operand = this.doReadOperand(true);
        return new NotExpression(operand);
    }

    private Expression readNegativeNumber() throws LineNumberParseException, IOException {
        Number num;
        Token subtractToken = this.tokenizer.readToken();
        if (subtractToken == null) {
            throw this.createParseException("Expected '-', found end of expression", this.tokenizer.getLineNum(), this.tokenizer.getColNum());
        }
        if (subtractToken.getType() != Token.Type.SUBTRACT) {
            throw this.createParseException("Expected '-', found: " + subtractToken.getText(), subtractToken);
        }
        Token numToken = this.tokenizer.readToken();
        if (numToken == null) {
            throw this.createParseException("Expected number, found end of expression", this.tokenizer.getLineNum(), this.tokenizer.getColNum());
        }
        if (numToken.getType() != Token.Type.NUMBER) {
            throw this.createParseException("Expected number, found: " + numToken.getText(), numToken);
        }
        try {
            num = numToken.getValue().asNumber();
        }
        catch (EvaluationException ex) {
            throw new RuntimeException("Unexpected error: " + ex.getMessage(), ex);
        }
        Number negNum = Value.isIntNumber(num) ? (Number)Value.normalizeNumber(-num.longValue()) : (Number)(-num.doubleValue());
        Token token = new Token(Token.Type.NUMBER, "-" + numToken.getText(), subtractToken.getLineNum(), subtractToken.getColNum(), subtractToken.getPosition(), new Value(negNum));
        return new ValueExpression(token);
    }

    private Expression readPostfixOperator(Token.Type token, Expression parentOperand) throws LineNumberParseException, IOException {
        switch (token) {
            case DOT: {
                return this.readDot(parentOperand);
            }
            case BRACKET_OPEN: {
                return this.readIndex(parentOperand);
            }
        }
        throw new RuntimeException("Unknown postfix operator: " + (Object)((Object)token));
    }

    private Expression readDot(Expression parentOperand) throws LineNumberParseException, IOException {
        Token token = this.tokenizer.readToken();
        if (token == null) {
            throw this.createParseException("Expected '.', found end of expression", this.tokenizer.getLineNum(), this.tokenizer.getColNum());
        }
        if (token.getType() != Token.Type.DOT) {
            throw this.createParseException("Expected '.', found: " + token.getText(), token);
        }
        Expression parsed = this.doReadOperand(true, true);
        return new DotExpression(parentOperand, parsed);
    }

    private Expression readIndex(Expression parentOperand) throws LineNumberParseException, IOException {
        Token token = this.tokenizer.readToken();
        if (token == null) {
            throw this.createParseException("Expected '[', found end of expression", this.tokenizer.getLineNum(), this.tokenizer.getColNum());
        }
        if (token.getType() != Token.Type.BRACKET_OPEN) {
            throw this.createParseException("Expected '[', found: " + token.getText(), token);
        }
        Expression parsed = this.doReadExpression(true);
        token = this.tokenizer.readToken();
        if (token == null) {
            throw this.createParseException("Incomplete index expression", this.tokenizer.getLineNum(), this.tokenizer.getColNum());
        }
        if (token.getType() != Token.Type.BRACKET_CLOSE) {
            throw this.createParseException("Expected ']', found: " + token.getText(), token);
        }
        return new IndexExpression(parentOperand, parsed);
    }

    private Expression readList() throws LineNumberParseException, IOException {
        Token token = this.tokenizer.readToken();
        if (token == null) {
            throw this.createParseException("Expected '[', found end of expression", this.tokenizer.getLineNum(), this.tokenizer.getColNum());
        }
        if (token.getType() != Token.Type.BRACKET_OPEN) {
            throw this.createParseException("Expected '[', found: " + token.getText(), token);
        }
        boolean prevIsComma = false;
        ArrayList<Expression> elements = new ArrayList<Expression>();
        while ((token = this.tokenizer.readToken()) != null) {
            Expression parsed;
            if (prevIsComma) {
                this.tokenizer.rewind();
                parsed = this.doReadExpression(true);
                elements.add(parsed);
                prevIsComma = false;
                continue;
            }
            if (token.getType() == Token.Type.COMMA) {
                if (elements.isEmpty()) {
                    throw this.createParseException("Expected expression or ']', found ','", token);
                }
                prevIsComma = true;
                continue;
            }
            if (token.getType() == Token.Type.BRACKET_CLOSE) {
                return new ListExpression(elements);
            }
            if (!elements.isEmpty()) {
                throw this.createParseException("Expected ',' or ']', found: " + token.getText(), token);
            }
            this.tokenizer.rewind();
            parsed = this.doReadExpression(true);
            elements.add(parsed);
        }
        throw this.createParseException("Incomplete list", this.tokenizer.getLineNum(), this.tokenizer.getColNum());
    }

    private Expression readGroup() throws LineNumberParseException, IOException {
        Token token = this.tokenizer.readToken();
        if (token == null) {
            throw this.createParseException("Expected '(', found end of expression", this.tokenizer.getLineNum(), this.tokenizer.getColNum());
        }
        if (token.getType() != Token.Type.PARENTHESIS_OPEN) {
            throw this.createParseException("Expected '(', found: " + token.getText(), token);
        }
        Expression expression = this.doReadExpression(true);
        token = this.tokenizer.readToken();
        if (token == null) {
            throw this.createParseException("Incomplete group", this.tokenizer.getLineNum(), this.tokenizer.getColNum());
        }
        if (token.getType() != Token.Type.PARENTHESIS_CLOSE) {
            throw this.createParseException("Expected ')', found: " + token.getText(), token);
        }
        return new GroupExpression(expression);
    }

    private Expression readObject() throws LineNumberParseException, IOException {
        Token token = this.tokenizer.readToken();
        if (token == null) {
            throw this.createParseException("Expected '{', found end of expression", this.tokenizer.getLineNum(), this.tokenizer.getColNum());
        }
        if (token.getType() != Token.Type.BRACE_OPEN) {
            throw this.createParseException("Expected '{', found: " + token.getText(), token);
        }
        ArrayList<ObjectExpression.KeyValue> properties = new ArrayList<ObjectExpression.KeyValue>();
        Expression currentKey = null;
        boolean prevIsComma = false;
        boolean prevIsColon = false;
        while ((token = this.tokenizer.readToken()) != null) {
            if (prevIsColon) {
                this.tokenizer.rewind();
                Expression parsed = this.doReadExpression(true);
                properties.add(new ObjectExpression.KeyValue(currentKey, parsed));
                prevIsColon = false;
                currentKey = null;
                continue;
            }
            if (prevIsComma) {
                this.tokenizer.rewind();
                currentKey = this.doReadExpression(true);
                prevIsComma = false;
                continue;
            }
            if (currentKey != null) {
                if (token.getType() != Token.Type.COLON) {
                    throw this.createParseException("Expected ':', found: " + token.getText(), token);
                }
                prevIsColon = true;
                continue;
            }
            if (token.getType() == Token.Type.COLON) {
                if (properties.isEmpty()) {
                    throw this.createParseException("Expected expression or '}', found ':'", token);
                }
                throw this.createParseException("Expected ',' or '}', found ':'", token);
            }
            if (token.getType() == Token.Type.COMMA) {
                if (properties.isEmpty()) {
                    throw this.createParseException("Expected expression or '}', found ','", token);
                }
                prevIsComma = true;
                continue;
            }
            if (token.getType() == Token.Type.BRACE_CLOSE) {
                return new ObjectExpression(properties);
            }
            if (!properties.isEmpty()) {
                throw this.createParseException("Expected ',' or '}', found: " + token.getText(), token);
            }
            this.tokenizer.rewind();
            currentKey = this.doReadExpression(true);
        }
        throw this.createParseException("Incomplete object", this.tokenizer.getLineNum(), this.tokenizer.getColNum());
    }

    private LineNumberParseException createParseException(String message, Token token) {
        return new LineNumberParseException(message, token.getLineNum(), token.getColNum());
    }

    private LineNumberParseException createParseException(String message, int lineNum, int colNum) {
        return new LineNumberParseException(message, lineNum, colNum);
    }

    private class ExpressionElement {
        public Expression operand = null;
        public Token operator = null;

        public ExpressionElement(Expression operand) {
            this.operand = operand;
        }

        public ExpressionElement(Token operator) {
            this.operator = operator;
        }
    }
}

