/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.expressions.types;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.rrd.wool.expressions.EvaluationException;
import nl.rrd.wool.expressions.Expression;
import nl.rrd.wool.expressions.Value;

public class DivideExpression
implements Expression {
    private Expression operand1;
    private Expression operand2;

    public DivideExpression(Expression operand1, Expression operand2) {
        this.operand1 = operand1;
        this.operand2 = operand2;
    }

    public Expression getOperand1() {
        return this.operand1;
    }

    public Expression getOperand2() {
        return this.operand2;
    }

    @Override
    public Value evaluate(Map<String, Object> variables) throws EvaluationException {
        long l2;
        long l1;
        Number num1 = this.operand1.evaluate(variables).asNumber();
        Number num2 = this.operand2.evaluate(variables).asNumber();
        if (Value.isIntNumber(num1) && Value.isIntNumber(num2) && (l1 = num1.longValue()) % (l2 = num2.longValue()) == 0L) {
            return new Value(Value.normalizeNumber(num1.longValue() / num2.longValue()));
        }
        return new Value(num1.doubleValue() / num2.doubleValue());
    }

    @Override
    public List<Expression> getChildren() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        result.add(this.operand1);
        result.add(this.operand2);
        return result;
    }

    @Override
    public List<Expression> getDescendants() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        for (Expression child : this.getChildren()) {
            result.add(child);
            result.addAll(child.getDescendants());
        }
        return result;
    }

    @Override
    public Set<String> getVariableNames() {
        HashSet<String> result = new HashSet<String>();
        for (Expression child : this.getChildren()) {
            result.addAll(child.getVariableNames());
        }
        return result;
    }

    public String toString() {
        return this.operand1 + " / " + this.operand2;
    }
}

