/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.expressions.types;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.rrd.wool.expressions.EvaluationException;
import nl.rrd.wool.expressions.Expression;
import nl.rrd.wool.expressions.Value;

public class LessThanExpression
implements Expression {
    private Expression operand1;
    private Expression operand2;

    public LessThanExpression(Expression operand1, Expression operand2) {
        this.operand1 = operand1;
        this.operand2 = operand2;
    }

    public Expression getOperand1() {
        return this.operand1;
    }

    public Expression getOperand2() {
        return this.operand2;
    }

    @Override
    public Value evaluate(Map<String, Object> variables) throws EvaluationException {
        Value[] vals = new Value[]{this.operand1.evaluate(variables), this.operand2.evaluate(variables)};
        for (Value val : vals) {
            if (val.isString() || val.isNumber()) continue;
            throw new EvaluationException("Operand of < must be a string or number, found: " + val.getTypeString());
        }
        if (vals[0].isString() || vals[1].isString()) {
            return new Value(vals[0].toString().compareTo(vals[1].toString()) < 0);
        }
        Number num1 = vals[0].asNumber();
        Number num2 = vals[1].asNumber();
        if (Value.isIntNumber(num1) && Value.isIntNumber(num2)) {
            return new Value(num1.longValue() < num2.longValue());
        }
        return new Value(num1.doubleValue() < num2.doubleValue());
    }

    @Override
    public List<Expression> getChildren() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        result.add(this.operand1);
        result.add(this.operand2);
        return result;
    }

    @Override
    public List<Expression> getDescendants() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        for (Expression child : this.getChildren()) {
            result.add(child);
            result.addAll(child.getDescendants());
        }
        return result;
    }

    @Override
    public Set<String> getVariableNames() {
        HashSet<String> result = new HashSet<String>();
        for (Expression child : this.getChildren()) {
            result.addAll(child.getVariableNames());
        }
        return result;
    }

    public String toString() {
        return this.operand1 + " < " + this.operand2;
    }
}

