/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.expressions.types;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.rrd.wool.expressions.EvaluationException;
import nl.rrd.wool.expressions.Expression;
import nl.rrd.wool.expressions.Value;

public class ListExpression
implements Expression {
    private List<Expression> elements;

    public ListExpression(List<Expression> elements) {
        this.elements = elements;
    }

    public List<Expression> getElements() {
        return this.elements;
    }

    @Override
    public Value evaluate(Map<String, Object> variables) throws EvaluationException {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Expression expr : this.elements) {
            result.add(expr.evaluate(variables).getValue());
        }
        return new Value(result);
    }

    @Override
    public List<Expression> getChildren() {
        return new ArrayList<Expression>(this.elements);
    }

    @Override
    public List<Expression> getDescendants() {
        ArrayList<Expression> result = new ArrayList<Expression>();
        for (Expression child : this.getChildren()) {
            result.add(child);
            result.addAll(child.getDescendants());
        }
        return result;
    }

    @Override
    public Set<String> getVariableNames() {
        HashSet<String> result = new HashSet<String>();
        for (Expression child : this.getChildren()) {
            result.addAll(child.getVariableNames());
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Expression elem : this.elements) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(elem);
        }
        return "[" + builder + "]";
    }
}

