/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.expressions.types;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.rrd.wool.expressions.EvaluationException;
import nl.rrd.wool.expressions.Expression;
import nl.rrd.wool.expressions.Token;
import nl.rrd.wool.expressions.Value;

public class ValueExpression
implements Expression {
    private Token token;

    public ValueExpression(Token token) {
        this.token = token;
    }

    public Token getToken() {
        return this.token;
    }

    @Override
    public Value evaluate(Map<String, Object> variables) throws EvaluationException {
        if (this.token.getType() == Token.Type.NAME || this.token.getType() == Token.Type.DOLLAR_VARIABLE) {
            if (variables == null) {
                return new Value(null);
            }
            return new Value(variables.get(this.token.getValue().toString()));
        }
        return this.token.getValue();
    }

    @Override
    public List<Expression> getChildren() {
        return new ArrayList<Expression>();
    }

    @Override
    public List<Expression> getDescendants() {
        return new ArrayList<Expression>();
    }

    @Override
    public Set<String> getVariableNames() {
        HashSet<String> result = new HashSet<String>();
        if (this.token.getType() == Token.Type.NAME || this.token.getType() == Token.Type.DOLLAR_VARIABLE) {
            result.add(this.token.getValue().toString());
        }
        return result;
    }

    public String toString() {
        return this.token.getText();
    }
}

