/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import nl.rrd.wool.i18n.I18nResourceFinder;
import nl.rrd.wool.utils.ResourceLocator;

public class I18nLanguageFinder {
    private I18nResourceFinder finder;
    private List<String> available;

    public I18nLanguageFinder(List<String> available) {
        this.available = available;
        this.finder = new I18nResourceFinder("");
        this.finder.setExtension(null);
        this.finder.setResourceLocator(new StringMapLocator());
    }

    public void setUserLocale(Locale userLocale) {
        this.finder.setUserLocale(userLocale);
    }

    public void setUserLocales(List<Locale> userLocales) {
        this.finder.setUserLocales(userLocales);
    }

    public void setHonorifics(boolean honorifics) {
        this.finder.setHonorifics(honorifics);
    }

    public String find() {
        if (!this.finder.find()) {
            return null;
        }
        return this.finder.getName();
    }

    private class StringMapLocator
    implements ResourceLocator {
        private StringMapLocator() {
        }

        @Override
        public boolean resourceExists(String path) {
            return I18nLanguageFinder.this.available.contains(path);
        }

        @Override
        public InputStream openResource(String path) throws IOException {
            return null;
        }
    }
}

