/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import nl.rrd.wool.utils.ClassLoaderResourceLocator;
import nl.rrd.wool.utils.ResourceLocator;

public class I18nResourceFinder {
    private String baseName;
    private List<Locale> userLocales = new ArrayList<Locale>();
    private boolean honorifics = true;
    private String extension = "properties";
    private Locale locale = null;
    private String name = null;
    private ResourceLocator resourceLocator = new ClassLoaderResourceLocator();

    public I18nResourceFinder(String baseName) {
        this.baseName = baseName;
        this.userLocales.add(Locale.getDefault());
    }

    public void setUserLocale(Locale userLocale) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        locales.add(userLocale);
        this.setUserLocales(locales);
    }

    public void setUserLocales(List<Locale> userLocales) {
        this.userLocales = userLocales;
    }

    public void setHonorifics(boolean honorifics) {
        this.honorifics = honorifics;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setResourceLocator(ResourceLocator resourceLocator) {
        this.resourceLocator = resourceLocator;
    }

    public boolean find() {
        this.locale = null;
        this.name = null;
        ArrayList<Locale> prefLocales = new ArrayList<Locale>(this.userLocales);
        prefLocales.add(Locale.UK);
        prefLocales.add(Locale.US);
        prefLocales.add(Locale.ENGLISH);
        for (Locale locale : prefLocales) {
            if (!this.findResource(locale)) continue;
            return true;
        }
        return false;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getName() {
        return this.name;
    }

    public InputStream openStream() throws IOException {
        return this.resourceLocator.openResource(this.name);
    }

    private boolean findResource(Locale locale) {
        ArrayList<String> prefResources = new ArrayList<String>();
        if (locale.getCountry().length() > 0) {
            this.addPrefResource(prefResources, String.format("%s_%s_%s", locale.getLanguage(), locale.getCountry(), this.honorifics ? "v" : "t"));
            this.addPrefResource(prefResources, String.format("%s_%s", locale.getLanguage(), locale.getCountry()));
        }
        this.addPrefResource(prefResources, String.format("%s_%s", locale.getLanguage(), this.honorifics ? "v" : "t"));
        this.addPrefResource(prefResources, locale.getLanguage());
        this.addPrefResource(prefResources, this.honorifics ? "v" : "t");
        this.addPrefResource(prefResources, null);
        for (String name : prefResources) {
            if (!this.resourceLocator.resourceExists(name)) continue;
            this.locale = locale;
            this.name = name;
            return true;
        }
        return false;
    }

    private void addPrefResource(List<String> prefResources, String tokens) {
        String name = this.baseName;
        if (name == null) {
            name = "";
        }
        if (name.length() > 0 && tokens != null && tokens.length() > 0) {
            name = name + "_";
        }
        if (tokens != null) {
            name = name + tokens;
        }
        if (this.extension != null) {
            name = name + "." + this.extension;
        }
        prefResources.add(name);
    }
}

