/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.i18n;

import java.util.ArrayList;
import java.util.List;
import nl.rrd.wool.i18n.WoolTranslatable;
import nl.rrd.wool.model.WoolNode;
import nl.rrd.wool.model.WoolNodeBody;
import nl.rrd.wool.model.WoolReply;
import nl.rrd.wool.model.WoolVariableString;
import nl.rrd.wool.model.command.WoolCommand;
import nl.rrd.wool.model.command.WoolIfCommand;
import nl.rrd.wool.model.command.WoolInputCommand;

public class WoolTranslatableExtractor {
    public List<WoolTranslatable> extractFromNode(WoolNode node) {
        return this.extractFromBody(node.getBody());
    }

    public List<WoolTranslatable> extractFromBody(WoolNodeBody body) {
        ArrayList<WoolTranslatable> result = new ArrayList<WoolTranslatable>();
        ArrayList<WoolNodeBody.Segment> current = new ArrayList<WoolNodeBody.Segment>();
        for (int i = 0; i < body.getSegments().size(); ++i) {
            WoolNodeBody.Segment segment = body.getSegments().get(i);
            if (segment instanceof WoolNodeBody.TextSegment) {
                WoolNodeBody.TextSegment textSegment = (WoolNodeBody.TextSegment)segment;
                current.add(textSegment);
                continue;
            }
            if (!(segment instanceof WoolNodeBody.CommandSegment)) continue;
            WoolNodeBody.CommandSegment cmdSegment = (WoolNodeBody.CommandSegment)segment;
            WoolCommand cmd = cmdSegment.getCommand();
            if (cmd instanceof WoolIfCommand) {
                WoolIfCommand ifCmd = (WoolIfCommand)cmd;
                this.finishCurrentTranslatableSegment(body, current, result);
                result.addAll(this.getTranslatableSegmentsFromIfCommand(ifCmd));
                continue;
            }
            if (!(cmd instanceof WoolInputCommand)) continue;
            current.add(segment);
        }
        this.finishCurrentTranslatableSegment(body, current, result);
        for (WoolReply reply : body.getReplies()) {
            if (reply.getStatement() == null) continue;
            result.addAll(this.extractFromBody(reply.getStatement()));
        }
        return result;
    }

    private List<WoolTranslatable> getTranslatableSegmentsFromIfCommand(WoolIfCommand ifCmd) {
        ArrayList<WoolTranslatable> result = new ArrayList<WoolTranslatable>();
        for (WoolIfCommand.Clause clause : ifCmd.getIfClauses()) {
            result.addAll(this.extractFromBody(clause.getStatement()));
        }
        if (ifCmd.getElseClause() != null) {
            result.addAll(this.extractFromBody(ifCmd.getElseClause()));
        }
        return result;
    }

    private void finishCurrentTranslatableSegment(WoolNodeBody parent, List<WoolNodeBody.Segment> current, List<WoolTranslatable> translatables) {
        if (this.containsText(current)) {
            ArrayList<WoolNodeBody.Segment> segments = new ArrayList<WoolNodeBody.Segment>(current);
            WoolNodeBody.trimWhitespace(segments);
            translatables.add(new WoolTranslatable(parent, segments));
        }
        current.clear();
    }

    private boolean containsText(List<WoolNodeBody.Segment> segments) {
        for (WoolNodeBody.Segment segment : segments) {
            WoolNodeBody.TextSegment textSegment;
            WoolVariableString string;
            if (!(segment instanceof WoolNodeBody.TextSegment) || !this.containsText(string = (textSegment = (WoolNodeBody.TextSegment)segment).getText())) continue;
            return true;
        }
        return false;
    }

    private boolean containsText(WoolVariableString string) {
        for (WoolVariableString.Segment segment : string.getSegments()) {
            if (!(segment instanceof WoolVariableString.TextSegment)) continue;
            return true;
        }
        return false;
    }
}

