/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.i18n;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nl.rrd.wool.exception.LineNumberParseException;
import nl.rrd.wool.exception.ParseException;
import nl.rrd.wool.i18n.WoolTranslatable;
import nl.rrd.wool.i18n.WoolTranslatableExtractor;
import nl.rrd.wool.i18n.WoolTranslationParserResult;
import nl.rrd.wool.json.JsonMapper;
import nl.rrd.wool.model.WoolNodeBody;
import nl.rrd.wool.parser.WoolBodyParser;
import nl.rrd.wool.parser.WoolBodyToken;
import nl.rrd.wool.parser.WoolBodyTokenizer;
import nl.rrd.wool.utils.FileUtils;

public class WoolTranslationParser {
    public static WoolTranslationParserResult parse(URL url) throws IOException {
        try (InputStream input = url.openStream();){
            WoolTranslationParserResult woolTranslationParserResult = WoolTranslationParser.parse(input);
            return woolTranslationParserResult;
        }
    }

    public static WoolTranslationParserResult parse(File file) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            WoolTranslationParserResult woolTranslationParserResult = WoolTranslationParser.parse(input);
            return woolTranslationParserResult;
        }
    }

    public static WoolTranslationParserResult parse(InputStream input) throws IOException {
        return WoolTranslationParser.parse(new InputStreamReader(input, StandardCharsets.UTF_8));
    }

    public static WoolTranslationParserResult parse(Reader reader) throws IOException {
        Map map;
        WoolTranslationParserResult result = new WoolTranslationParserResult();
        LinkedHashMap<WoolTranslatable, WoolTranslatable> translations = new LinkedHashMap<WoolTranslatable, WoolTranslatable>();
        String json = FileUtils.readFileString(reader);
        if (json.trim().isEmpty()) {
            result.getWarnings().add("Empty translation file");
            result.setTranslations(translations);
            return result;
        }
        try {
            map = (Map)JsonMapper.parse(json, new TypeReference<Map<String, ?>>(){});
        }
        catch (ParseException ex) {
            result.getParseErrors().add(ex);
            return result;
        }
        WoolTranslationParser.parse(map, translations, result);
        if (result.getParseErrors().isEmpty()) {
            result.setTranslations(translations);
        }
        return result;
    }

    private static void parse(Map<String, ?> map, Map<WoolTranslatable, WoolTranslatable> translations, WoolTranslationParserResult parseResult) {
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof String) {
                WoolTranslationParser.parseTranslatable(key, (String)value, translations, parseResult);
                continue;
            }
            WoolTranslationParser.parseContextMap(key, value, translations, parseResult);
        }
    }

    private static void parseTranslatable(String key, String value, Map<WoolTranslatable, WoolTranslatable> translations, WoolTranslationParserResult parseResult) {
        boolean success = true;
        WoolTranslatable transKey = null;
        try {
            transKey = WoolTranslationParser.parseTranslationString(key);
        }
        catch (ParseException ex) {
            parseResult.getParseErrors().add(new ParseException(String.format("Failed to parse translation key \"%s\"", key) + ": " + ex.getMessage(), ex));
            success = false;
        }
        if (transKey != null && translations.containsKey(transKey)) {
            parseResult.getParseErrors().add(new ParseException("Found duplicate translation key: " + transKey));
            success = false;
        }
        if (value.trim().isEmpty()) {
            parseResult.getWarnings().add(String.format("Empty translation value for key \"%s\"", key));
            return;
        }
        WoolTranslatable transValue = null;
        try {
            transValue = WoolTranslationParser.parseTranslationString(value);
        }
        catch (ParseException ex) {
            parseResult.getParseErrors().add(new ParseException(String.format("Failed to parse translation value for key \"%s\"", key) + ": " + value + ": " + ex.getMessage(), ex));
            success = false;
        }
        if (success) {
            translations.put(transKey, transValue);
        }
    }

    private static void parseContextMap(String key, Object value, Map<WoolTranslatable, WoolTranslatable> translations, WoolTranslationParserResult parseResult) {
        Map map;
        try {
            map = (Map)JsonMapper.convert(value, new TypeReference<Map<String, ?>>(){});
        }
        catch (ParseException ex) {
            parseResult.getParseErrors().add(new ParseException("Failed to parse translation map after context key \"" + key + "\": " + ex.getMessage(), ex));
            return;
        }
        WoolTranslationParser.parse(map, translations, parseResult);
    }

    private static WoolTranslatable parseTranslationString(String translation) throws ParseException {
        WoolNodeBody body;
        List<WoolBodyToken> tokens;
        WoolBodyTokenizer tokenizer = new WoolBodyTokenizer();
        try {
            tokens = tokenizer.readBodyTokens(translation, 1);
        }
        catch (LineNumberParseException ex) {
            throw new ParseException("Invalid translation string: " + translation + ": " + ex.getError());
        }
        WoolBodyParser parser = new WoolBodyParser(null);
        try {
            body = parser.parse(tokens, Collections.singletonList("input"));
        }
        catch (LineNumberParseException ex) {
            throw new ParseException("Invalid translation string: " + translation + ": " + ex.getError());
        }
        WoolTranslatableExtractor extractor = new WoolTranslatableExtractor();
        List<WoolTranslatable> translatables = extractor.extractFromBody(body);
        if (translatables.size() == 0) {
            throw new ParseException("Invalid translation string: " + translation + ": No translatable text found");
        }
        if (translatables.size() != 1) {
            throw new ParseException("Invalid translation string: " + translation + ": Multiple translatable texts found");
        }
        return translatables.get(0);
    }
}

