/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nl.rrd.wool.i18n.WoolTranslatable;
import nl.rrd.wool.i18n.WoolTranslatableExtractor;
import nl.rrd.wool.model.WoolDialogue;
import nl.rrd.wool.model.WoolNode;
import nl.rrd.wool.model.WoolNodeBody;

public class WoolTranslator {
    private Map<WoolTranslatable, WoolTranslatable> translations;

    public WoolTranslator(Map<WoolTranslatable, WoolTranslatable> translations) {
        this.translations = translations;
    }

    public WoolDialogue translate(WoolDialogue dialogue) {
        dialogue = new WoolDialogue(dialogue);
        for (WoolNode node : dialogue.getNodes()) {
            this.translateBody(node.getBody());
        }
        return dialogue;
    }

    public WoolNode translate(WoolNode node) {
        node = new WoolNode(node);
        this.translateBody(node.getBody());
        return node;
    }

    private void translateBody(WoolNodeBody body) {
        WoolTranslatableExtractor extractor = new WoolTranslatableExtractor();
        List<WoolTranslatable> translatables = extractor.extractFromBody(body);
        for (WoolTranslatable translatable : translatables) {
            this.translateText(translatable);
        }
    }

    private void translateText(WoolTranslatable text) {
        WoolTranslatable translation = this.translations.get(text);
        if (translation == null) {
            return;
        }
        WoolNodeBody body = text.getParent();
        ArrayList<WoolNodeBody.Segment> bodySegments = new ArrayList<WoolNodeBody.Segment>(body.getSegments());
        List<WoolNodeBody.Segment> textSegments = text.getSegments();
        int insertIndex = body.getSegments().indexOf(textSegments.get(0));
        for (WoolNodeBody.Segment segment : textSegments) {
            bodySegments.remove(segment);
        }
        List<WoolNodeBody.Segment> transSegments = translation.getSegments();
        for (int i = 0; i < transSegments.size(); ++i) {
            bodySegments.add(insertIndex + i, transSegments.get(i));
        }
        body.clearSegments();
        for (WoolNodeBody.Segment segment : bodySegments) {
            body.addSegment(segment);
        }
    }
}

