/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.model;

import java.util.LinkedHashMap;
import java.util.Map;

public class WoolNodeHeader {
    private String title;
    private String speaker;
    private Map<String, String> optionalTags;

    public WoolNodeHeader() {
        this.optionalTags = new LinkedHashMap<String, String>();
    }

    public WoolNodeHeader(String title) {
        this.title = title;
        this.optionalTags = new LinkedHashMap<String, String>();
    }

    public WoolNodeHeader(String title, Map<String, String> optionalTags) {
        this.title = title;
        this.optionalTags = optionalTags;
    }

    public WoolNodeHeader(WoolNodeHeader other) {
        this.title = other.title;
        this.speaker = other.speaker;
        this.optionalTags = new LinkedHashMap<String, String>(other.optionalTags);
    }

    public String getTitle() {
        return this.title;
    }

    public String getSpeaker() {
        return this.speaker;
    }

    public Map<String, String> getOptionalTags() {
        return this.optionalTags;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSpeaker(String speaker) {
        this.speaker = speaker;
    }

    public void setOptionalTags(Map<String, String> optionalTags) {
        this.optionalTags = optionalTags;
    }

    public void addOptionalTag(String key, String value) {
        this.optionalTags.put(key, value);
    }

    public String toString() {
        String newline = System.getProperty("line.separator");
        StringBuilder result = new StringBuilder();
        result.append("title: " + this.title);
        if (this.speaker != null) {
            result.append(newline + "speaker: " + this.speaker);
        }
        for (String key : this.optionalTags.keySet()) {
            String value = this.optionalTags.get(key);
            result.append(newline + key + ": " + value);
        }
        return result.toString();
    }
}

