/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.rrd.wool.expressions.Value;

public class WoolVariableString {
    private List<Segment> segments = new ArrayList<Segment>();

    public WoolVariableString() {
    }

    public WoolVariableString(String text) {
        this.segments.add(new TextSegment(text));
    }

    public WoolVariableString(WoolVariableString other) {
        for (Segment segment : other.segments) {
            this.segments.add(segment.clone());
        }
    }

    public List<Segment> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public void addSegment(Segment segment) {
        Segment lastSegment = null;
        if (!this.segments.isEmpty()) {
            lastSegment = this.segments.get(this.segments.size() - 1);
        }
        if (lastSegment instanceof TextSegment && segment instanceof TextSegment) {
            TextSegment lastTextSegment = (TextSegment)lastSegment;
            TextSegment textSegment = (TextSegment)segment;
            TextSegment mergedSegment = new TextSegment(lastTextSegment.text + textSegment.text);
            this.segments.remove(this.segments.size() - 1);
            this.segments.add(mergedSegment);
        } else {
            this.segments.add(segment);
        }
    }

    public void addSegments(Iterable<Segment> segments) {
        for (Segment segment : segments) {
            this.addSegment(segment);
        }
    }

    public WoolVariableString execute(Map<String, Object> variables) {
        WoolVariableString result = new WoolVariableString();
        for (Segment segment : this.segments) {
            if (segment instanceof TextSegment) {
                result.addSegment(segment);
                continue;
            }
            VariableSegment varSegment = (VariableSegment)segment;
            Object valueObj = null;
            if (variables != null) {
                valueObj = variables.get(varSegment.variableName);
            }
            Value value = new Value(valueObj);
            result.addSegment(new TextSegment(value.toString()));
        }
        return result;
    }

    public String evaluate(Map<String, Object> variables) {
        WoolVariableString varStr = this.execute(variables);
        if (varStr.segments.isEmpty()) {
            return "";
        }
        TextSegment segment = (TextSegment)varStr.segments.get(0);
        return segment.text;
    }

    public void getReadVariableNames(Set<String> varNames) {
        for (Segment segment : this.segments) {
            if (!(segment instanceof VariableSegment)) continue;
            VariableSegment varSegment = (VariableSegment)segment;
            varNames.add(varSegment.variableName);
        }
    }

    public boolean isWhitespace() {
        for (Segment segment : this.segments) {
            if (!(segment instanceof TextSegment)) {
                return false;
            }
            TextSegment textSegment = (TextSegment)segment;
            if (textSegment.text.trim().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isPlainText() {
        for (Segment segment : this.segments) {
            if (segment instanceof TextSegment) continue;
            return false;
        }
        return true;
    }

    public void trimWhitespace() {
        this.removeLeadingWhitespace();
        this.removeTrailingWhitespace();
    }

    public void removeLeadingWhitespace() {
        while (!this.segments.isEmpty()) {
            Segment segment = this.segments.get(0);
            if (!(segment instanceof TextSegment)) {
                return;
            }
            TextSegment textSegment = (TextSegment)segment;
            String content = textSegment.getText().replaceAll("^\\s+", "");
            textSegment.setText(content);
            if (content.length() > 0) {
                return;
            }
            this.segments.remove(0);
        }
    }

    public void removeTrailingWhitespace() {
        while (!this.segments.isEmpty()) {
            Segment segment = this.segments.get(this.segments.size() - 1);
            if (!(segment instanceof TextSegment)) {
                return;
            }
            TextSegment textSegment = (TextSegment)segment;
            String content = textSegment.getText().replaceAll("\\s+$", "");
            textSegment.setText(content);
            if (content.length() > 0) {
                return;
            }
            this.segments.remove(this.segments.size() - 1);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Segment segment : this.segments) {
            result.append(segment.toString());
        }
        return result.toString();
    }

    public String toString(char[] escapes) {
        StringBuilder result = new StringBuilder();
        for (Segment segment : this.segments) {
            if (segment instanceof TextSegment) {
                result.append(((TextSegment)segment).toString(escapes));
                continue;
            }
            result.append(segment.toString());
        }
        return result.toString();
    }

    public static class VariableSegment
    extends Segment {
        private String variableName;

        public VariableSegment(String variableName) {
            this.variableName = variableName;
        }

        public VariableSegment(VariableSegment other) {
            this.variableName = other.variableName;
        }

        public String getVariableName() {
            return this.variableName;
        }

        public void setVariableName(String variableName) {
            this.variableName = variableName;
        }

        public String toString() {
            return "$" + this.variableName;
        }

        @Override
        public VariableSegment clone() {
            return new VariableSegment(this);
        }
    }

    public static class TextSegment
    extends Segment {
        private String text;

        public TextSegment(String text) {
            this.text = text;
        }

        public TextSegment(TextSegment other) {
            this.text = other.text;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$");
        }

        public String toString(char[] escapes) {
            String input = this.toString();
            StringBuilder builder = new StringBuilder();
            int start = 0;
            block0: for (int i = 0; i < input.length(); ++i) {
                char c = input.charAt(i);
                for (char escape : escapes) {
                    if (c != escape) continue;
                    builder.append(input, start, i);
                    builder.append('\\');
                    builder.append(c);
                    start = i + 1;
                    continue block0;
                }
            }
            if (start < input.length()) {
                builder.append(input.substring(start));
            }
            return builder.toString();
        }

        @Override
        public TextSegment clone() {
            return new TextSegment(this);
        }
    }

    public static abstract class Segment
    implements Cloneable {
        public abstract Segment clone();
    }
}

