/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.model.command;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.rrd.wool.exception.LineNumberParseException;
import nl.rrd.wool.expressions.EvaluationException;
import nl.rrd.wool.model.WoolNodeBody;
import nl.rrd.wool.model.WoolReply;
import nl.rrd.wool.model.WoolVariableString;
import nl.rrd.wool.model.command.WoolAttributesCommand;
import nl.rrd.wool.model.nodepointer.WoolNodePointer;
import nl.rrd.wool.parser.WoolBodyToken;
import nl.rrd.wool.parser.WoolNodeState;
import nl.rrd.wool.utils.CurrentIterator;

public class WoolActionCommand
extends WoolAttributesCommand {
    public static final String TYPE_IMAGE = "image";
    public static final String TYPE_VIDEO = "video";
    public static final String TYPE_GENERIC = "generic";
    private static final List<String> VALID_TYPES = Arrays.asList("image", "video", "generic");
    private String type;
    private WoolVariableString value;
    private Map<String, WoolVariableString> parameters = new LinkedHashMap<String, WoolVariableString>();

    public WoolActionCommand(String type, WoolVariableString value) {
        this.type = type;
        this.value = value;
    }

    public WoolActionCommand(WoolActionCommand other) {
        this.type = other.type;
        this.value = new WoolVariableString(other.value);
        for (String key : other.parameters.keySet()) {
            this.parameters.put(key, new WoolVariableString(other.parameters.get(key)));
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public WoolVariableString getValue() {
        return this.value;
    }

    public void setValue(WoolVariableString value) {
        this.value = value;
    }

    public Map<String, WoolVariableString> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, WoolVariableString> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(String name, WoolVariableString value) {
        this.parameters.put(name, value);
    }

    @Override
    public WoolReply findReplyById(int replyId) {
        return null;
    }

    @Override
    public void getReadVariableNames(Set<String> varNames) {
        this.value.getReadVariableNames(varNames);
        for (WoolVariableString paramVals : this.parameters.values()) {
            paramVals.getReadVariableNames(varNames);
        }
    }

    @Override
    public void getWriteVariableNames(Set<String> varNames) {
    }

    @Override
    public void getNodePointers(Set<WoolNodePointer> pointers) {
    }

    @Override
    public void executeBodyCommand(Map<String, Object> variables, WoolNodeBody processedBody) throws EvaluationException {
        WoolActionCommand processedCommand = new WoolActionCommand(this.type, this.value.execute(variables));
        for (String param : this.parameters.keySet()) {
            WoolVariableString value = this.parameters.get(param);
            processedCommand.addParameter(param, value.execute(variables));
        }
        processedBody.addSegment(new WoolNodeBody.CommandSegment(processedCommand));
    }

    public String toString() {
        char[] escapes = new char[]{'\"'};
        StringBuilder result = new StringBuilder("<<action type=\"" + this.type + "\" value=\"" + this.value.toString(escapes) + "\"");
        for (String key : this.parameters.keySet()) {
            result.append(" " + key + "=\"" + this.parameters.get(key).toString(escapes) + "\"");
        }
        result.append(">>");
        return result.toString();
    }

    public static WoolActionCommand parse(WoolBodyToken cmdStartToken, CurrentIterator<WoolBodyToken> tokens, WoolNodeState nodeState) throws LineNumberParseException {
        Map<String, WoolBodyToken> attrs = WoolActionCommand.parseAttributesCommand(cmdStartToken, tokens);
        String type = WoolActionCommand.readPlainTextAttr("type", attrs, cmdStartToken, true);
        WoolBodyToken token = attrs.get("type");
        if (!VALID_TYPES.contains(type)) {
            throw new LineNumberParseException("Invalid value for attribute \"type\": " + type, token.getLineNum(), token.getColNum());
        }
        attrs.remove("type");
        WoolVariableString value = WoolActionCommand.readAttr("value", attrs, cmdStartToken, true);
        attrs.remove("value");
        WoolActionCommand command = new WoolActionCommand(type, value);
        for (String attr : attrs.keySet()) {
            token = attrs.get(attr);
            command.addParameter(attr, (WoolVariableString)token.getValue());
        }
        return command;
    }

    @Override
    public WoolActionCommand clone() {
        return new WoolActionCommand(this);
    }
}

