/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.model.command;

import java.io.IOException;
import java.io.StringReader;
import nl.rrd.wool.exception.LineNumberParseException;
import nl.rrd.wool.expressions.Expression;
import nl.rrd.wool.expressions.ExpressionParser;
import nl.rrd.wool.expressions.Token;
import nl.rrd.wool.expressions.Tokenizer;
import nl.rrd.wool.io.LineColumnNumberReader;
import nl.rrd.wool.model.command.WoolCommand;
import nl.rrd.wool.parser.WoolBodyToken;
import nl.rrd.wool.utils.CurrentIterator;

public abstract class WoolExpressionCommand
extends WoolCommand {
    protected static ReadContentResult readCommandContent(WoolBodyToken cmdStartToken, CurrentIterator<WoolBodyToken> tokens) throws LineNumberParseException {
        ReadContentResult result = new ReadContentResult();
        result.lineNum = tokens.getCurrent().getLineNum();
        result.colNum = tokens.getCurrent().getColNum();
        StringBuilder text = new StringBuilder();
        boolean foundEnd = false;
        while (!foundEnd && tokens.getCurrent() != null) {
            WoolBodyToken token = tokens.getCurrent();
            if (token.getType() == WoolBodyToken.Type.COMMAND_END) {
                foundEnd = true;
            } else {
                text.append(tokens.getCurrent().getText());
            }
            tokens.moveNext();
        }
        if (!foundEnd) {
            throw new LineNumberParseException("Command not terminated", cmdStartToken.getLineNum(), cmdStartToken.getColNum());
        }
        result.content = text.toString();
        return result;
    }

    protected static ParseContentResult parseCommandContentName(WoolBodyToken cmdStartToken, ReadContentResult content, String name) throws LineNumberParseException {
        ParseContentResult result = WoolExpressionCommand.parseCommandContent(cmdStartToken, content);
        if (!result.name.equals(name)) {
            throw new LineNumberParseException(String.format("Expected command \"%s\", found: %s", name, result.name), cmdStartToken.getLineNum(), cmdStartToken.getColNum());
        }
        if (result.expression != null) {
            throw new LineNumberParseException(String.format("Unexpected content after command name \"%s\"", name), cmdStartToken.getLineNum(), cmdStartToken.getColNum());
        }
        return result;
    }

    protected static ParseContentResult parseCommandContentExpression(WoolBodyToken cmdStartToken, ReadContentResult content, String name) throws LineNumberParseException {
        ParseContentResult result = WoolExpressionCommand.parseCommandContent(cmdStartToken, content);
        if (!result.name.equals(name)) {
            throw new LineNumberParseException(String.format("Expected command \"%s\", found: %s", name, result.name), cmdStartToken.getLineNum(), cmdStartToken.getColNum());
        }
        if (result.expression == null) {
            throw new LineNumberParseException(String.format("Expression not found in command \"%s\"", name), cmdStartToken.getLineNum(), cmdStartToken.getColNum());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ParseContentResult parseCommandContent(WoolBodyToken cmdStartToken, ReadContentResult content) throws LineNumberParseException {
        ParseContentResult parseContentResult;
        int lineOff = content.lineNum;
        int colOff = content.colNum;
        LineColumnNumberReader reader = new LineColumnNumberReader(new StringReader(content.content));
        Tokenizer tokenizer = new Tokenizer(reader);
        ExpressionParser parser = new ExpressionParser(tokenizer);
        try {
            parser.getConfig().setAllowDollarVariables(true);
            parser.getConfig().setAllowPlainVariables(false);
            parseContentResult = WoolExpressionCommand.parseCommandContent(cmdStartToken, content, tokenizer, parser, lineOff, colOff);
        }
        catch (Throwable throwable) {
            try {
                parser.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        parser.close();
        return parseContentResult;
    }

    private static ParseContentResult parseCommandContent(WoolBodyToken cmdStartToken, ReadContentResult content, Tokenizer tokenizer, ExpressionParser parser, int lineOff, int colOff) throws LineNumberParseException, IOException {
        Token nextToken;
        Token nameToken;
        ParseContentResult result = new ParseContentResult();
        try {
            nameToken = tokenizer.readToken();
        }
        catch (LineNumberParseException ex) {
            throw WoolExpressionCommand.createParseException("Invalid command name: " + ex.getError(), ex, lineOff, colOff);
        }
        if (nameToken == null) {
            throw new LineNumberParseException("Found empty command", cmdStartToken.getLineNum(), cmdStartToken.getColNum());
        }
        if (nameToken.getType() != Token.Type.NAME) {
            throw WoolExpressionCommand.createParseException("Expected command name, found token: " + (Object)((Object)nameToken.getType()), nameToken.getLineNum(), nameToken.getColNum(), lineOff, colOff);
        }
        result.name = nameToken.getValue().toString();
        try {
            result.expression = parser.readExpression();
        }
        catch (LineNumberParseException ex) {
            throw WoolExpressionCommand.createParseException("Invalid expression in command: " + ex.getError(), ex, lineOff, colOff);
        }
        int postExprLine = tokenizer.getLineNum();
        int postExprCol = tokenizer.getColNum();
        try {
            nextToken = tokenizer.readToken();
        }
        catch (LineNumberParseException ex) {
            throw WoolExpressionCommand.createParseException("Unexpected content after expression in command", postExprLine, postExprCol, lineOff, colOff);
        }
        if (nextToken != null) {
            throw WoolExpressionCommand.createParseException("Unexpected content after expression in command", postExprLine, postExprCol, lineOff, colOff);
        }
        return result;
    }

    private static LineNumberParseException createParseException(String message, LineNumberParseException ex, int lineOff, int colOff) throws LineNumberParseException {
        return WoolExpressionCommand.createParseException(message, ex.getLineNum(), ex.getColNum(), lineOff, colOff);
    }

    private static LineNumberParseException createParseException(String message, int lineNum, int colNum, int lineOff, int colOff) throws LineNumberParseException {
        int exLineNum = lineOff - 1 + lineNum;
        int exColNum = colNum;
        if (exLineNum == lineOff) {
            exColNum += colOff - 1;
        }
        return new LineNumberParseException(message, exLineNum, exColNum);
    }

    protected static class ParseContentResult {
        public String name;
        public Expression expression;

        protected ParseContentResult() {
        }
    }

    protected static class ReadContentResult {
        public String content;
        public int lineNum;
        public int colNum;

        protected ReadContentResult() {
        }
    }
}

