/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.model.command;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import nl.rrd.wool.exception.LineNumberParseException;
import nl.rrd.wool.execution.WoolVariableStore;
import nl.rrd.wool.expressions.EvaluationException;
import nl.rrd.wool.expressions.Value;
import nl.rrd.wool.model.WoolNodeBody;
import nl.rrd.wool.model.command.WoolInputCommand;
import nl.rrd.wool.parser.WoolBodyToken;

public class WoolInputTextCommand
extends WoolInputCommand {
    private String variableName;
    private Integer min = null;
    private Integer max = null;

    public WoolInputTextCommand(String variableName) {
        super("text");
        this.variableName = variableName;
    }

    public WoolInputTextCommand(WoolInputTextCommand other) {
        super(other);
        this.variableName = other.variableName;
        this.min = other.min;
        this.max = other.max;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    @Override
    public Map<String, ?> getParameters() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("variableName", this.variableName);
        result.put("min", this.min);
        result.put("max", this.max);
        return result;
    }

    @Override
    public void getReadVariableNames(Set<String> varNames) {
    }

    @Override
    public void getWriteVariableNames(Set<String> varNames) {
        varNames.add(this.variableName);
    }

    @Override
    public void executeBodyCommand(Map<String, Object> variables, WoolNodeBody processedBody) throws EvaluationException {
        processedBody.addSegment(new WoolNodeBody.CommandSegment(this));
    }

    @Override
    public String getStatementLog(WoolVariableStore varStore) {
        Value value = new Value(varStore.getValue(this.variableName));
        return value.toString();
    }

    public String toString() {
        String result = "<<input type=\"text\" value=\"$" + this.variableName + "\"";
        if (this.min != null) {
            result = result + " min=\"" + this.min + "\"";
        }
        if (this.max != null) {
            result = result + " max=\"" + this.max + "\"";
        }
        result = result + ">>";
        return result;
    }

    @Override
    public WoolInputTextCommand clone() {
        return new WoolInputTextCommand(this);
    }

    public static WoolInputCommand parse(WoolBodyToken cmdStartToken, Map<String, WoolBodyToken> attrs) throws LineNumberParseException {
        String variableName = WoolInputTextCommand.readVariableAttr("value", attrs, cmdStartToken, true);
        WoolInputTextCommand command = new WoolInputTextCommand(variableName);
        Integer min = WoolInputTextCommand.readIntAttr("min", attrs, cmdStartToken, false, null, null);
        command.setMin(min);
        Integer max = WoolInputTextCommand.readIntAttr("max", attrs, cmdStartToken, false, null, null);
        command.setMax(max);
        return command;
    }
}

