/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.model.command;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import nl.rrd.wool.exception.LineNumberParseException;
import nl.rrd.wool.expressions.EvaluationException;
import nl.rrd.wool.expressions.Expression;
import nl.rrd.wool.expressions.types.AssignExpression;
import nl.rrd.wool.model.WoolNodeBody;
import nl.rrd.wool.model.WoolReply;
import nl.rrd.wool.model.command.WoolExpressionCommand;
import nl.rrd.wool.model.nodepointer.WoolNodePointer;
import nl.rrd.wool.parser.WoolBodyToken;
import nl.rrd.wool.parser.WoolNodeState;
import nl.rrd.wool.utils.CurrentIterator;

public class WoolSetCommand
extends WoolExpressionCommand {
    private AssignExpression expression;

    public WoolSetCommand(AssignExpression expression) {
        this.expression = expression;
    }

    public WoolSetCommand(WoolSetCommand other) {
        this.expression = other.expression;
    }

    public AssignExpression getExpression() {
        return this.expression;
    }

    public void setExpression(AssignExpression expression) {
        this.expression = expression;
    }

    @Override
    public WoolReply findReplyById(int replyId) {
        return null;
    }

    @Override
    public void getReadVariableNames(Set<String> varNames) {
        varNames.addAll(this.expression.getValueOperand().getVariableNames());
    }

    @Override
    public void getWriteVariableNames(Set<String> varNames) {
        varNames.add(this.expression.getVariableName());
    }

    @Override
    public void getNodePointers(Set<WoolNodePointer> pointers) {
    }

    @Override
    public void executeBodyCommand(Map<String, Object> variables, WoolNodeBody processedBody) throws EvaluationException {
        this.expression.evaluate(variables);
    }

    public String toString() {
        return "<<set " + this.expression + ">>";
    }

    @Override
    public WoolSetCommand clone() {
        return new WoolSetCommand(this);
    }

    public static WoolSetCommand parse(WoolBodyToken cmdStartToken, CurrentIterator<WoolBodyToken> tokens, WoolNodeState nodeState) throws LineNumberParseException {
        WoolExpressionCommand.ReadContentResult content = WoolSetCommand.readCommandContent(cmdStartToken, tokens);
        WoolExpressionCommand.ParseContentResult parsed = WoolSetCommand.parseCommandContentExpression(cmdStartToken, content, "set");
        if (!(parsed.expression instanceof AssignExpression)) {
            throw new LineNumberParseException("Expression in \"set\" command is not an assignment", cmdStartToken.getLineNum(), cmdStartToken.getColNum());
        }
        AssignExpression assignExpr = (AssignExpression)parsed.expression;
        WoolSetCommand.checkNoAssignment(cmdStartToken, assignExpr.getValueOperand());
        return new WoolSetCommand(assignExpr);
    }

    private static void checkNoAssignment(WoolBodyToken cmdStartToken, Expression expression) throws LineNumberParseException {
        ArrayList<Expression> list = new ArrayList<Expression>();
        list.add(expression);
        list.addAll(expression.getDescendants());
        for (Expression expr : list) {
            if (!(expr instanceof AssignExpression)) continue;
            throw new LineNumberParseException("Found assignment expression in value operand of \"set\" command", cmdStartToken.getLineNum(), cmdStartToken.getColNum());
        }
    }
}

