/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.parser;

import java.util.List;
import nl.rrd.wool.exception.LineNumberParseException;
import nl.rrd.wool.model.WoolNodeBody;
import nl.rrd.wool.model.WoolReply;
import nl.rrd.wool.model.WoolVariableString;
import nl.rrd.wool.model.command.WoolCommand;
import nl.rrd.wool.parser.WoolBodyToken;
import nl.rrd.wool.parser.WoolCommandParser;
import nl.rrd.wool.parser.WoolNodeState;
import nl.rrd.wool.parser.WoolReplyParser;
import nl.rrd.wool.utils.CurrentIterator;

public class WoolBodyParser {
    private WoolNodeState nodeState;

    public WoolBodyParser(WoolNodeState nodeState) {
        this.nodeState = nodeState;
    }

    public WoolNodeBody parse(List<WoolBodyToken> tokens, List<String> validCommands) throws LineNumberParseException {
        CurrentIterator<WoolBodyToken> it = new CurrentIterator<WoolBodyToken>(tokens.iterator());
        it.moveNext();
        ParseUntilIfClauseResult result = this.parseUntilIfClause(it, validCommands);
        if (result.ifClauseStartToken != null) {
            WoolBodyToken token = it.getCurrent();
            throw new LineNumberParseException(String.format("Unexpected command \"%s\"", result.ifClauseName), token.getLineNum(), token.getColNum());
        }
        return result.body;
    }

    public ParseUntilIfClauseResult parseUntilIfClause(CurrentIterator<WoolBodyToken> tokens, List<String> validCommands) throws LineNumberParseException {
        ParseUntilIfClauseResult result = new ParseUntilIfClauseResult();
        result.body = new WoolNodeBody();
        block5: while (result.ifClauseStartToken == null && tokens.getCurrent() != null) {
            WoolBodyToken token = tokens.getCurrent();
            switch (token.getType()) {
                case TEXT: 
                case VARIABLE: {
                    WoolVariableString text = this.parseTextSegment(tokens);
                    if (result.body.getReplies().isEmpty()) {
                        result.body.addSegment(new WoolNodeBody.TextSegment(text));
                        continue block5;
                    }
                    if (text.isWhitespace()) continue block5;
                    throw new LineNumberParseException("Found content after reply", token.getLineNum(), token.getColNum());
                }
                case COMMAND_START: {
                    WoolCommandParser cmdParser = new WoolCommandParser(validCommands, this.nodeState);
                    String name = cmdParser.readCommandName(tokens);
                    if (name.equals("elseif") || name.equals("else") || name.equals("endif")) {
                        result.ifClauseStartToken = token;
                        result.ifClauseName = name;
                        continue block5;
                    }
                    if (!name.equals("if") && !result.body.getReplies().isEmpty()) {
                        throw new LineNumberParseException("Found << after reply", token.getLineNum(), token.getColNum());
                    }
                    WoolCommand command = cmdParser.parseFromName(token, tokens);
                    result.body.addSegment(new WoolNodeBody.CommandSegment(command));
                    continue block5;
                }
                case REPLY_START: {
                    WoolReplyParser replyParser = new WoolReplyParser(this.nodeState);
                    WoolReply reply = replyParser.parse(tokens);
                    if (reply.getStatement() == null && this.hasAutoForwardReply(result.body)) {
                        throw new LineNumberParseException("Found more than one autoforward reply", token.getLineNum(), token.getColNum());
                    }
                    result.body.addReply(reply);
                    continue block5;
                }
            }
            throw new LineNumberParseException("Unexpected token type: " + (Object)((Object)token.getType()), token.getLineNum(), token.getColNum());
        }
        result.body.trimWhitespace();
        return result;
    }

    private boolean hasAutoForwardReply(WoolNodeBody body) {
        for (WoolReply reply : body.getReplies()) {
            if (reply.getStatement() != null) continue;
            return true;
        }
        return false;
    }

    private WoolVariableString parseTextSegment(CurrentIterator<WoolBodyToken> tokens) {
        WoolVariableString string = new WoolVariableString();
        boolean foundEnd = false;
        while (!foundEnd && tokens.getCurrent() != null) {
            WoolBodyToken token = tokens.getCurrent();
            switch (token.getType()) {
                case TEXT: {
                    string.addSegment(new WoolVariableString.TextSegment((String)token.getValue()));
                    break;
                }
                case VARIABLE: {
                    string.addSegment(new WoolVariableString.VariableSegment((String)token.getValue()));
                    break;
                }
                default: {
                    foundEnd = true;
                }
            }
            if (foundEnd) continue;
            tokens.moveNext();
        }
        return string;
    }

    public class ParseUntilIfClauseResult {
        public WoolNodeBody body;
        public WoolBodyToken ifClauseStartToken = null;
        public String ifClauseName = null;
    }
}

