/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.parser;

import java.util.ArrayList;
import java.util.List;
import nl.rrd.wool.utils.CurrentIterator;

public class WoolBodyToken {
    private Type type;
    private int lineNum;
    private int colNum;
    private String text;
    private Object value = null;

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public void setLineNum(int lineNum) {
        this.lineNum = lineNum;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public static void trimWhitespace(List<WoolBodyToken> tokens) {
        WoolBodyToken.removeLeadingWhitespace(tokens);
        WoolBodyToken.removeTrailingWhitespace(tokens);
    }

    public static void removeLeadingWhitespace(List<WoolBodyToken> tokens) {
        while (!tokens.isEmpty()) {
            WoolBodyToken token = tokens.get(0);
            if (token.getType() != Type.TEXT) {
                return;
            }
            String text = (String)token.getValue();
            text = text.replaceAll("^\\s+", "");
            token.setValue(text);
            if (text.length() > 0) {
                return;
            }
            tokens.remove(0);
        }
    }

    public static void removeTrailingWhitespace(List<WoolBodyToken> tokens) {
        while (!tokens.isEmpty()) {
            WoolBodyToken token = tokens.get(tokens.size() - 1);
            if (token.getType() != Type.TEXT) {
                return;
            }
            String text = (String)token.getValue();
            text = text.replaceAll("\\s+$", "");
            token.setValue(text);
            if (text.length() > 0) {
                return;
            }
            tokens.remove(tokens.size() - 1);
        }
    }

    public static List<WoolBodyToken> skipWhitespace(CurrentIterator<WoolBodyToken> tokens) {
        ArrayList<WoolBodyToken> result = new ArrayList<WoolBodyToken>();
        while (tokens.getCurrent() != null) {
            WoolBodyToken token = tokens.getCurrent();
            if (token.getType() != Type.TEXT) {
                return result;
            }
            String text = (String)token.getValue();
            if (!text.trim().isEmpty()) {
                return result;
            }
            result.add(token);
            tokens.moveNext();
        }
        return result;
    }

    public static enum Type {
        TEXT,
        COMMAND_START,
        COMMAND_END,
        REPLY_START,
        REPLY_END,
        REPLY_SEPARATOR,
        QUOTED_STRING,
        VARIABLE;

    }
}

