/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.parser;

import java.util.List;
import nl.rrd.wool.exception.LineNumberParseException;
import nl.rrd.wool.model.command.WoolActionCommand;
import nl.rrd.wool.model.command.WoolCommand;
import nl.rrd.wool.model.command.WoolIfCommand;
import nl.rrd.wool.model.command.WoolInputCommand;
import nl.rrd.wool.model.command.WoolSetCommand;
import nl.rrd.wool.parser.WoolBodyToken;
import nl.rrd.wool.parser.WoolNodeState;
import nl.rrd.wool.utils.CurrentIterator;

public class WoolCommandParser {
    private List<String> validCommands;
    private WoolNodeState nodeState;

    public WoolCommandParser(List<String> validCommands, WoolNodeState nodeState) {
        this.validCommands = validCommands;
        this.nodeState = nodeState;
    }

    public String readCommandName(CurrentIterator<WoolBodyToken> tokens) throws LineNumberParseException {
        WoolBodyToken startToken = tokens.getCurrent();
        tokens.moveNext();
        WoolBodyToken.skipWhitespace(tokens);
        WoolBodyToken token = tokens.getCurrent();
        return this.getCommandName(startToken, token);
    }

    public WoolCommand parseFromName(WoolBodyToken startToken, CurrentIterator<WoolBodyToken> tokens) throws LineNumberParseException {
        WoolBodyToken token = tokens.getCurrent();
        String name = this.getCommandName(startToken, token);
        if (!this.validCommands.contains(name)) {
            throw new LineNumberParseException("Unexpected command: " + name, token.getLineNum(), token.getColNum());
        }
        switch (name) {
            case "action": {
                return WoolActionCommand.parse(startToken, tokens, this.nodeState);
            }
            case "if": {
                return WoolIfCommand.parse(startToken, tokens, this.nodeState);
            }
            case "input": {
                return WoolInputCommand.parse(startToken, tokens, this.nodeState);
            }
            case "set": {
                return WoolSetCommand.parse(startToken, tokens, this.nodeState);
            }
        }
        throw new LineNumberParseException("Unknown command: " + name, token.getLineNum(), token.getColNum());
    }

    public WoolCommand parseFromStart(CurrentIterator<WoolBodyToken> tokens) throws LineNumberParseException {
        WoolBodyToken startToken = tokens.getCurrent();
        tokens.moveNext();
        WoolBodyToken.skipWhitespace(tokens);
        return this.parseFromName(startToken, tokens);
    }

    private String getCommandName(WoolBodyToken startToken, WoolBodyToken nameToken) throws LineNumberParseException {
        if (nameToken == null) {
            throw new LineNumberParseException("Command not terminated", startToken.getLineNum(), startToken.getColNum());
        }
        if (nameToken.getType() != WoolBodyToken.Type.TEXT) {
            throw new LineNumberParseException("Expected command name, found token: " + (Object)((Object)nameToken.getType()), nameToken.getLineNum(), nameToken.getColNum());
        }
        String name = nameToken.getText().trim();
        String[] split = name.split("\\s+", 2);
        return split[0];
    }
}

