/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nl.rrd.wool.exception.LineNumberParseException;
import nl.rrd.wool.exception.ParseException;
import nl.rrd.wool.exception.WoolNodeParseException;
import nl.rrd.wool.io.LineColumnNumberReader;
import nl.rrd.wool.model.WoolDialogue;
import nl.rrd.wool.model.WoolNode;
import nl.rrd.wool.model.WoolNodeBody;
import nl.rrd.wool.model.WoolNodeHeader;
import nl.rrd.wool.model.nodepointer.WoolNodePointerInternal;
import nl.rrd.wool.parser.WoolBodyParser;
import nl.rrd.wool.parser.WoolBodyToken;
import nl.rrd.wool.parser.WoolBodyTokenizer;
import nl.rrd.wool.parser.WoolNodeState;
import nl.rrd.wool.parser.WoolParserResult;

public class WoolParser
implements AutoCloseable {
    public static final String NODE_NAME_REGEX = "[A-Za-z0-9_-]+";
    private String dialogueName;
    private LineColumnNumberReader reader;
    private WoolDialogue dialogue = null;
    private List<WoolNodeState.NodePointerToken> nodePointerTokens = null;

    public WoolParser(String filename) throws FileNotFoundException {
        this(new File(filename));
    }

    public WoolParser(File file) throws FileNotFoundException {
        this.init(file);
    }

    public WoolParser(String dialogueName, InputStream input) {
        this.init(dialogueName, input);
    }

    public WoolParser(String dialogueName, Reader reader) {
        this.init(dialogueName, new LineColumnNumberReader(reader));
    }

    private void init(File file) throws FileNotFoundException {
        String name = file.getName();
        int extSep = name.lastIndexOf(46);
        if (extSep != -1) {
            name = name.substring(0, extSep);
        }
        this.init(name, new FileInputStream(file));
    }

    private void init(String dialogueName, InputStream input) {
        try {
            this.init(dialogueName, new InputStreamReader(input, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 not supported: " + ex.getMessage(), ex);
        }
    }

    private void init(String dialogueName, Reader reader) {
        this.dialogueName = dialogueName;
        this.reader = reader instanceof LineColumnNumberReader ? (LineColumnNumberReader)reader : (reader instanceof BufferedReader ? new LineColumnNumberReader(reader) : new LineColumnNumberReader(new BufferedReader(reader)));
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public WoolParserResult readDialogue() throws IOException {
        ReadWoolNodeResult readResult;
        WoolDialogue dialogue;
        WoolParserResult result = new WoolParserResult();
        if (!this.dialogueName.matches(NODE_NAME_REGEX)) {
            result.getParseErrors().add(new ParseException("Invalid dialogue name: " + this.dialogueName));
        }
        this.dialogue = dialogue = new WoolDialogue(this.dialogueName);
        this.nodePointerTokens = new ArrayList<WoolNodeState.NodePointerToken>();
        boolean foundNodeError = false;
        while ((readResult = this.readNode()) != null) {
            if (readResult.node != null) {
                dialogue.addNode(readResult.node);
                continue;
            }
            foundNodeError = true;
            result.getParseErrors().add(readResult.parseException);
            if (readResult.readNodeEnd) continue;
            this.moveToNextNode();
        }
        if (foundNodeError) {
            return result;
        }
        if (!dialogue.nodeExists("Start")) {
            result.getParseErrors().add(new LineNumberParseException("Node with title \"Start\" not found", this.reader.getLineNum(), this.reader.getColNum()));
        }
        for (WoolNodeState.NodePointerToken pointerToken : this.nodePointerTokens) {
            WoolNodePointerInternal pointer;
            if (!(pointerToken.getPointer() instanceof WoolNodePointerInternal) || dialogue.nodeExists((pointer = (WoolNodePointerInternal)pointerToken.getPointer()).getNodeId())) continue;
            WoolBodyToken token = pointerToken.getToken();
            LineNumberParseException parseEx = new LineNumberParseException("Found reply with pointer to non-existing node: " + pointer.getNodeId(), token.getLineNum(), token.getColNum());
            result.getParseErrors().add(this.createWoolNodeParseException(pointerToken.getNodeTitle(), parseEx));
        }
        if (!result.getParseErrors().isEmpty()) {
            return result;
        }
        result.setDialogue(dialogue);
        this.dialogue = null;
        this.nodePointerTokens = null;
        return result;
    }

    private ReadWoolNodeResult readNode() throws IOException {
        ReadWoolNodeResult result = new ReadWoolNodeResult();
        WoolNodeState nodeState = new WoolNodeState();
        try {
            boolean inHeader = true;
            LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>();
            int lineNum = this.reader.getLineNum();
            String line = this.readLine();
            while (line != null && inHeader) {
                if (this.getContent(line).equals("===")) {
                    result.readNodeEnd = true;
                    throw new LineNumberParseException("End of header not found", lineNum, 1);
                }
                if (this.getContent(line).equals("---")) {
                    inHeader = false;
                    continue;
                }
                this.parseHeaderLine(headerMap, line, lineNum, nodeState);
                lineNum = this.reader.getLineNum();
                line = this.readLine();
            }
            if (inHeader) {
                if (nodeState.getTitle() == null && nodeState.getSpeaker() == null && headerMap.isEmpty()) {
                    return null;
                }
                throw new LineNumberParseException("Found incomplete node at end of file", this.reader.getLineNum(), this.reader.getColNum());
            }
            WoolNodeHeader header = this.createHeader(headerMap, lineNum, nodeState);
            boolean inBody = true;
            WoolBodyTokenizer tokenizer = new WoolBodyTokenizer();
            lineNum = this.reader.getLineNum();
            line = this.readLine();
            ArrayList<WoolBodyToken> bodyTokens = new ArrayList<WoolBodyToken>();
            while (line != null && inBody) {
                if (this.getContent(line).equals("===")) {
                    inBody = false;
                    result.readNodeEnd = true;
                    continue;
                }
                bodyTokens.addAll(tokenizer.readBodyTokens(line + "\n", lineNum));
                lineNum = this.reader.getLineNum();
                line = this.readLine();
            }
            WoolBodyParser bodyParser = new WoolBodyParser(nodeState);
            WoolNodeBody body = bodyParser.parse(bodyTokens, Arrays.asList("action", "if", "set"));
            if (header.getTitle().toLowerCase().equals("end")) {
                this.validateEndNode(header, body, bodyTokens);
            }
            this.nodePointerTokens.addAll(nodeState.getNodePointerTokens());
            result.node = new WoolNode(header, body);
            return result;
        }
        catch (LineNumberParseException ex) {
            result.parseException = this.createWoolNodeParseException(nodeState.getTitle(), ex);
            return result;
        }
    }

    private void validateEndNode(WoolNodeHeader header, WoolNodeBody body, List<WoolBodyToken> tokens) throws LineNumberParseException {
        if (body.getSegments().isEmpty() && body.getReplies().isEmpty()) {
            return;
        }
        WoolBodyToken token = tokens.get(0);
        throw new LineNumberParseException(String.format("Node \"%s\" must have an empty body", header.getTitle()), token.getLineNum(), token.getColNum());
    }

    private WoolNodeParseException createWoolNodeParseException(String nodeTitle, LineNumberParseException ex) {
        String msg = "Error in node";
        if (nodeTitle != null) {
            msg = msg + " " + nodeTitle;
        }
        return new WoolNodeParseException(msg + ": " + ex.getMessage(), nodeTitle, ex);
    }

    private void moveToNextNode() throws IOException {
        String line;
        while ((line = this.readLine()) != null) {
            if (!this.getContent(line).equals("===")) continue;
            return;
        }
    }

    private void parseHeaderLine(Map<String, String> headerMap, String line, int lineNum, WoolNodeState nodeState) throws LineNumberParseException {
        int commentSep = line.indexOf("//");
        if (commentSep != -1) {
            line = line.substring(0, commentSep);
        }
        if (line.trim().isEmpty()) {
            return;
        }
        int sep = line.indexOf(58);
        if (sep == -1) {
            throw new LineNumberParseException("Character : not found in header line", lineNum, 1);
        }
        String keyUntrimmed = line.substring(0, sep);
        String key = keyUntrimmed.trim();
        int keyIndex = 1;
        if (!key.isEmpty()) {
            keyIndex += WoolParser.skipWhitespace(keyUntrimmed, 0);
        }
        String valueUntrimmed = line.substring(sep + 1);
        String value = valueUntrimmed.trim();
        int valueCol = sep + 2 + WoolParser.skipWhitespace(valueUntrimmed, 0);
        if (key.length() == 0) {
            throw new LineNumberParseException("Found empty header name", lineNum, 0);
        }
        if (headerMap.containsKey(key)) {
            throw new LineNumberParseException("Found duplicate header: " + key, lineNum, keyIndex);
        }
        if (key.equals("title")) {
            if (!value.matches(NODE_NAME_REGEX)) {
                throw new LineNumberParseException("Invalid node title: " + value, lineNum, valueCol);
            }
            if (this.dialogue.nodeExists(value)) {
                throw new LineNumberParseException("Found duplicate node title: " + value, lineNum, valueCol);
            }
            nodeState.setTitle(value);
        } else if (key.equals("speaker")) {
            nodeState.setSpeaker(value);
            nodeState.setSpeakerLine(lineNum);
            nodeState.setSpeakerColumn(valueCol);
        } else {
            headerMap.put(key, value);
        }
    }

    private WoolNodeHeader createHeader(Map<String, String> headerMap, int lineNum, WoolNodeState nodeState) throws LineNumberParseException {
        String title = nodeState.getTitle();
        if (title == null) {
            throw new LineNumberParseException("Required header \"title\" not found", lineNum, 1);
        }
        String speaker = nodeState.getSpeaker();
        if (nodeState.getTitle().toLowerCase().equals("end")) {
            speaker = null;
        } else {
            if (speaker == null) {
                throw new LineNumberParseException("Required header \"speaker\" not found", lineNum, 1);
            }
            if (speaker.length() == 0) {
                throw new LineNumberParseException("Found empty speaker", nodeState.getSpeakerLine(), nodeState.getSpeakerColumn());
            }
        }
        WoolNodeHeader header = new WoolNodeHeader(title, headerMap);
        header.setSpeaker(speaker);
        return header;
    }

    private String getContent(String s) {
        if (s == null) {
            return null;
        }
        int commentIndex = s.indexOf("//");
        if (commentIndex != -1) {
            s = s.substring(0, commentIndex);
        }
        return s.trim();
    }

    public static int skipWhitespace(String s, int start) {
        int result = 0;
        for (int i = start; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isWhitespace(c)) {
                return result;
            }
            ++result;
        }
        return result;
    }

    private String readLine() throws IOException {
        StringBuilder builder = new StringBuilder();
        boolean foundCR = false;
        while (true) {
            if (foundCR) {
                Object restoreState = this.reader.getRestoreState(1);
                int c = this.reader.read();
                if (c == -1 || c == 10) {
                    this.reader.clearRestoreState(restoreState);
                } else {
                    this.reader.restoreState(restoreState);
                }
                return builder.toString();
            }
            int c = this.reader.read();
            if (c == -1) {
                if (builder.length() == 0) {
                    return null;
                }
                return builder.toString();
            }
            if (c == 10) {
                return builder.toString();
            }
            if (c == 13) {
                foundCR = true;
                continue;
            }
            builder.append((char)c);
        }
    }

    private static void showUsage() {
        System.out.println("Usage:");
        System.out.println("java " + WoolParser.class.getName() + " [options] <woolfile>");
        System.out.println("    Parse a .wool file and print a summary of the dialogue");
        System.out.println("");
        System.out.println("Options:");
        System.out.println("-h -? --help");
        System.out.println("    Print this usage message");
    }

    public static void main(String[] args) {
        WoolParserResult readResult;
        String filename = null;
        int i = 0;
        while (i < args.length) {
            String arg;
            if ((arg = args[i++]).equals("-h") || arg.equals("-?") || arg.equals("--help")) {
                WoolParser.showUsage();
                return;
            }
            filename = arg;
        }
        if (filename == null) {
            WoolParser.showUsage();
            System.exit(1);
            return;
        }
        File file = new File(filename);
        if (!file.exists()) {
            System.err.println("ERROR: File not found: " + filename);
            System.exit(1);
            return;
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!file.isFile()) {
            System.err.println("ERROR: Path is not a file: " + file.getAbsolutePath());
            System.exit(1);
            return;
        }
        try {
            WoolParser parser = new WoolParser(file);
            readResult = parser.readDialogue();
        }
        catch (IOException ex) {
            System.err.println("ERROR: Can't read file: " + file.getAbsolutePath() + ": " + ex.getMessage());
            System.exit(1);
            return;
        }
        if (!readResult.getParseErrors().isEmpty()) {
            System.err.println("ERROR: Failed to parse file: " + file.getAbsolutePath());
            for (ParseException ex : readResult.getParseErrors()) {
                System.err.println(ex.getMessage());
            }
            System.exit(1);
            return;
        }
        System.out.println("Finished parsing dialogue from file: " + file.getAbsolutePath());
        System.out.println(readResult.getDialogue());
    }

    private class ReadWoolNodeResult {
        public WoolNode node = null;
        public WoolNodeParseException parseException = null;
        public boolean readNodeEnd = false;

        private ReadWoolNodeResult() {
        }
    }
}

