/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import nl.rrd.wool.exception.ParseException;
import nl.rrd.wool.i18n.I18nLanguageFinder;
import nl.rrd.wool.i18n.WoolTranslatable;
import nl.rrd.wool.i18n.WoolTranslationParser;
import nl.rrd.wool.i18n.WoolTranslationParserResult;
import nl.rrd.wool.i18n.WoolTranslator;
import nl.rrd.wool.model.WoolDialogue;
import nl.rrd.wool.model.WoolDialogueDescription;
import nl.rrd.wool.model.WoolProject;
import nl.rrd.wool.parser.WoolFileDescription;
import nl.rrd.wool.parser.WoolFileLoader;
import nl.rrd.wool.parser.WoolParser;
import nl.rrd.wool.parser.WoolParserResult;
import nl.rrd.wool.parser.WoolProjectParserResult;

public class WoolProjectParser {
    private WoolFileLoader fileLoader;
    private Map<WoolFileDescription, WoolDialogue> dialogues = new LinkedHashMap<WoolFileDescription, WoolDialogue>();
    private Map<WoolFileDescription, Map<WoolTranslatable, WoolTranslatable>> translations = new LinkedHashMap<WoolFileDescription, Map<WoolTranslatable, WoolTranslatable>>();
    private Map<WoolDialogueDescription, WoolDialogue> translatedDialogues = new LinkedHashMap<WoolDialogueDescription, WoolDialogue>();

    public WoolProjectParser(WoolFileLoader fileLoader) {
        this.fileLoader = fileLoader;
    }

    public WoolProjectParserResult parse() throws IOException {
        WoolProjectParserResult result = new WoolProjectParserResult();
        List<WoolFileDescription> files = this.fileLoader.listWoolFiles();
        this.parseFiles(files, result);
        if (!result.getParseErrors().isEmpty()) {
            return result;
        }
        this.createTranslatedDialogues(result);
        if (!result.getParseErrors().isEmpty()) {
            return result;
        }
        WoolProject project = new WoolProject();
        project.setDialogues(this.translatedDialogues);
        result.setProject(project);
        return result;
    }

    private void parseFiles(List<WoolFileDescription> files, WoolProjectParserResult readResult) throws IOException {
        HashSet<WoolDialogueDescription> dlgDescrSet = new HashSet<WoolDialogueDescription>();
        ArrayList<WoolFileDescription> dialogueFiles = new ArrayList<WoolFileDescription>();
        ArrayList<WoolFileDescription> translationFiles = new ArrayList<WoolFileDescription>();
        for (WoolFileDescription file : files) {
            if (file.getFileName().endsWith(".wool")) {
                dialogueFiles.add(file);
                continue;
            }
            if (!file.getFileName().endsWith(".json")) continue;
            translationFiles.add(file);
        }
        for (WoolFileDescription descr : dialogueFiles) {
            dlgDescrSet.add(this.fileDescriptionToDialogueDescription(descr));
            WoolParserResult dlgReadResult = this.parseDialogueFile(descr);
            if (dlgReadResult.getParseErrors().isEmpty()) {
                this.dialogues.put(descr, dlgReadResult.getDialogue());
                continue;
            }
            this.getParseErrors(readResult, descr).addAll(dlgReadResult.getParseErrors());
        }
        for (WoolFileDescription descr : translationFiles) {
            WoolDialogueDescription dlgDescr = this.fileDescriptionToDialogueDescription(descr);
            if (dlgDescrSet.contains(dlgDescr)) {
                this.getParseErrors(readResult, descr).add(new ParseException(String.format("Found both translation file \"%s\" and dialogue file \"%s.wool\"", descr.getFileName(), dlgDescr.getDialogueName()) + ": " + descr));
                continue;
            }
            WoolTranslationParserResult transParseResult = this.parseTranslationFile(descr);
            if (!transParseResult.getParseErrors().isEmpty()) {
                this.getParseErrors(readResult, descr).addAll(transParseResult.getParseErrors());
            }
            if (!transParseResult.getWarnings().isEmpty()) {
                this.getWarnings(readResult, descr).addAll(transParseResult.getWarnings());
            }
            if (!transParseResult.getParseErrors().isEmpty()) continue;
            this.translations.put(descr, transParseResult.getTranslations());
        }
    }

    private List<ParseException> getParseErrors(WoolProjectParserResult readResult, WoolFileDescription descr) {
        String path = this.fileDescriptionToPath(descr);
        List<ParseException> errors = readResult.getParseErrors().get(path);
        if (errors != null) {
            return errors;
        }
        errors = new ArrayList<ParseException>();
        readResult.getParseErrors().put(path, errors);
        return errors;
    }

    private List<String> getWarnings(WoolProjectParserResult readResult, WoolFileDescription descr) {
        String path = this.fileDescriptionToPath(descr);
        List<String> warnings = readResult.getWarnings().get(path);
        if (warnings != null) {
            return warnings;
        }
        warnings = new ArrayList<String>();
        readResult.getWarnings().put(path, warnings);
        return warnings;
    }

    private void createTranslatedDialogues(WoolProjectParserResult readResult) {
        try {
            this.doCreateTranslatedDialogues(readResult);
        }
        finally {
            this.dialogues.clear();
            this.translations.clear();
        }
    }

    private void doCreateTranslatedDialogues(WoolProjectParserResult readResult) {
        WoolDialogueDescription dlgDescr;
        for (WoolFileDescription descr : this.dialogues.keySet()) {
            dlgDescr = this.fileDescriptionToDialogueDescription(descr);
            WoolDialogue dlg = this.dialogues.get(descr);
            this.translatedDialogues.put(dlgDescr, dlg);
        }
        for (WoolFileDescription descr : this.translations.keySet()) {
            dlgDescr = this.fileDescriptionToDialogueDescription(descr);
            WoolDialogue source = this.findSourceDialogue(dlgDescr.getMainSpeaker(), dlgDescr.getDialogueName());
            if (source == null) {
                this.getParseErrors(readResult, descr).add(new ParseException("No source dialogue found for translation: " + descr));
                continue;
            }
            WoolTranslator translator = new WoolTranslator(this.translations.get(descr));
            WoolDialogue translated = translator.translate(source);
            this.translatedDialogues.put(dlgDescr, translated);
        }
    }

    private WoolDialogue findSourceDialogue(String mainSpeaker, String dlgName) {
        ArrayList<WoolFileDescription> matches = new ArrayList<WoolFileDescription>();
        for (WoolFileDescription woolFileDescription : this.dialogues.keySet()) {
            String string = this.fileNameToDialogueName(woolFileDescription.getFileName());
            if (!woolFileDescription.getMainSpeaker().equals(mainSpeaker) || !string.equals(dlgName)) continue;
            matches.add(woolFileDescription);
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return this.dialogues.get(matches.get(0));
        }
        HashMap<String, WoolFileDescription> lngMap = new HashMap<String, WoolFileDescription>();
        for (WoolFileDescription woolFileDescription : matches) {
            lngMap.put(woolFileDescription.getLanguage(), woolFileDescription);
        }
        I18nLanguageFinder i18nLanguageFinder = new I18nLanguageFinder(new ArrayList<String>(lngMap.keySet()));
        i18nLanguageFinder.setUserLocale(Locale.ENGLISH);
        String string = i18nLanguageFinder.find();
        if (string == null) {
            return this.dialogues.get(matches.get(0));
        }
        return this.dialogues.get(lngMap.get(string));
    }

    private WoolParserResult parseDialogueFile(WoolFileDescription description) throws IOException {
        String dlgName = this.fileNameToDialogueName(description.getFileName());
        try (WoolParser woolParser = new WoolParser(dlgName, this.fileLoader.openFile(description));){
            WoolParserResult woolParserResult = woolParser.readDialogue();
            return woolParserResult;
        }
    }

    private WoolTranslationParserResult parseTranslationFile(WoolFileDescription description) throws IOException {
        try (Reader reader = this.fileLoader.openFile(description);){
            WoolTranslationParserResult woolTranslationParserResult = WoolTranslationParser.parse(reader);
            return woolTranslationParserResult;
        }
    }

    private WoolDialogueDescription fileDescriptionToDialogueDescription(WoolFileDescription descr) {
        WoolDialogueDescription result = new WoolDialogueDescription();
        result.setMainSpeaker(descr.getMainSpeaker());
        result.setLanguage(descr.getLanguage());
        result.setDialogueName(this.fileNameToDialogueName(descr.getFileName()));
        return result;
    }

    private String fileNameToDialogueName(String fileName) {
        if (fileName.endsWith(".wool") || fileName.endsWith(".json")) {
            return fileName.substring(0, fileName.length() - 5);
        }
        return fileName;
    }

    private String fileDescriptionToPath(WoolFileDescription descr) {
        return descr.getLanguage() + "/" + descr.getMainSpeaker() + "/" + descr.getFileName();
    }
}

