/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.parser;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nl.rrd.wool.exception.ParseException;
import nl.rrd.wool.json.JsonMapper;
import nl.rrd.wool.parser.WoolFileDescription;
import nl.rrd.wool.parser.WoolFileLoader;
import nl.rrd.wool.utils.FileUtils;

public class WoolResourceFileLoader
implements WoolFileLoader {
    private static final String PROJECT_FILE = "dialogues.json";
    private String resourcePath;

    public WoolResourceFileLoader(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    public List<WoolFileDescription> listWoolFiles() throws IOException {
        ArrayList<WoolFileDescription> result = new ArrayList<WoolFileDescription>();
        String path = this.resourcePath + "/" + PROJECT_FILE;
        InputStream input = this.getClass().getClassLoader().getResourceAsStream(path);
        try (InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);){
            String json = FileUtils.readFileString(reader);
            Map map = (Map)JsonMapper.parse(json, new TypeReference<Map<String, ?>>(){});
            for (String language : map.keySet()) {
                this.parseLanguageValue(language, map.get(language), result);
            }
        }
        catch (ParseException ex) {
            throw new IOException("Failed to parse resource " + path + ": " + ex.getMessage(), ex);
        }
        return result;
    }

    private void parseLanguageValue(String language, Object value, List<WoolFileDescription> files) throws ParseException {
        Map map = (Map)JsonMapper.convert(value, new TypeReference<Map<String, ?>>(){});
        for (String speaker : map.keySet()) {
            this.parseSpeakerValue(language, speaker, map.get(speaker), files);
        }
    }

    private void parseSpeakerValue(String language, String speaker, Object value, List<WoolFileDescription> files) throws ParseException {
        List<String> list = JsonMapper.convert(value, new TypeReference<List<String>>(){});
        for (String filename : list) {
            WoolFileDescription descr = new WoolFileDescription(speaker, language, filename);
            if (!filename.endsWith(".wool") && !filename.endsWith(".json")) continue;
            files.add(descr);
        }
    }

    @Override
    public Reader openFile(WoolFileDescription descr) throws IOException {
        String path = this.resourcePath + "/" + descr.getLanguage() + "/" + descr.getMainSpeaker() + "/" + descr.getFileName();
        return new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(path), StandardCharsets.UTF_8);
    }
}

