/*
 * Decompiled with CFR 0.152.
 */
package nl.rrd.wool.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import nl.rrd.wool.utils.ResourceLocator;

public class ClassLoaderResourceLocator
implements ResourceLocator {
    private Class<?> loadClass = null;

    public ClassLoaderResourceLocator() {
    }

    public ClassLoaderResourceLocator(Class<?> loadClass) {
        this.loadClass = loadClass;
    }

    @Override
    public boolean resourceExists(String path) {
        return this.findResource(path) != null;
    }

    @Override
    public InputStream openResource(String path) throws IOException {
        URL url = this.findResource(path);
        if (url == null) {
            throw new FileNotFoundException("Resource not found: " + path);
        }
        return url.openStream();
    }

    private URL findResource(String path) {
        if (this.loadClass == null) {
            return this.getClass().getClassLoader().getResource(path);
        }
        return this.loadClass.getResource(path);
    }
}

