/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils;

import eu.woolplatform.utils.AppComponentAttributeMapping;
import eu.woolplatform.utils.datetime.DateTimeUtils;
import eu.woolplatform.utils.exception.BuildException;
import eu.woolplatform.utils.exception.ParseException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AppComponents {
    private static AppComponents instance = null;
    private static final Object lock = new Object();
    private Set<Object> components = new HashSet<Object>();
    private List<AppComponentAttributeMapping<?>> attrMappings = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppComponents getInstance() {
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                instance = new AppComponents();
            }
            return instance;
        }
    }

    public static Logger getLogger(String name) {
        ILoggerFactory factory = AppComponents.getInstance().getComponent(ILoggerFactory.class, LoggerFactory.getILoggerFactory());
        return factory.getLogger(name);
    }

    public static <T> T get(Class<T> clazz) throws RuntimeException {
        return AppComponents.getInstance().getComponent(clazz);
    }

    private AppComponents() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addAttributeMapping(AppComponentAttributeMapping<T> mapping) {
        Object object = lock;
        synchronized (object) {
            this.attrMappings.add(mapping);
        }
    }

    public void buildComponents(File config) throws IOException, ParseException, BuildException {
        this.buildComponents(config.toURI().toURL());
    }

    public void buildComponents(URL config) throws IOException, ParseException, BuildException {
        try (InputStream in = config.openStream();){
            this.buildComponents(in);
        }
    }

    public void buildComponents(InputStream config) throws IOException, ParseException, BuildException {
        Document doc;
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new ParseException("Can't initialise XML parser: " + ex.getMessage());
        }
        try {
            doc = builder.parse(config);
        }
        catch (SAXException ex) {
            throw new ParseException("Can't parse XML file: " + ex.getMessage(), ex);
        }
        this.buildComponents(doc);
    }

    public void buildComponents(Document doc) throws ParseException, BuildException {
        this.buildComponents(doc.getDocumentElement());
    }

    public void buildComponents(Element elem) throws ParseException, BuildException {
        NodeList children = elem.getElementsByTagName("component");
        for (int i = 0; i < children.getLength(); ++i) {
            Element child = (Element)children.item(i);
            this.buildComponent(child);
        }
    }

    private void buildComponent(Element elem) throws ParseException, BuildException {
        Class<?> compClass;
        Attr attr = elem.getAttributeNode("class");
        if (attr == null) {
            throw new ParseException("Element \"component\" does not have attribute \"class\"");
        }
        String className = attr.getValue();
        try {
            compClass = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new BuildException("Class not found: " + className, ex);
        }
        NodeList children = elem.getElementsByTagName("attribute");
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (int i = 0; i < children.getLength(); ++i) {
            Element child = (Element)children.item(i);
            attr = child.getAttributeNode("name");
            if (attr == null) {
                throw new ParseException("Element \"attribute\" does not have attribute \"name\"");
            }
            String attrName = attr.getValue();
            if (attrName.length() == 0) {
                throw new ParseException("Attribute \"name\" is empty");
            }
            attr = child.getAttributeNode("value");
            if (attr == null) {
                throw new ParseException("Element \"attribute\" does not have attribute \"value\"");
            }
            String attrValue = attr.getValue();
            attributes.put(attrName, attrValue);
        }
        this.buildComponent(compClass, attributes);
    }

    private void buildComponent(Class<?> compClass, Map<String, String> attrs) throws BuildException {
        Object component = this.getDefaultComponent(compClass);
        for (String attr : attrs.keySet()) {
            this.setComponentAttribute(component, attr, attrs.get(attr));
        }
        this.components.add(component);
    }

    private void setComponentAttribute(Object component, String attr, String value) throws BuildException {
        Method[] methods;
        Class<?> compClass = component.getClass();
        Field field = null;
        try {
            field = compClass.getField(attr);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (field != null) {
            this.setAttributeField(field, component, value);
            return;
        }
        String methodName = "set" + attr.substring(0, 1).toUpperCase() + attr.substring(1);
        Method method = null;
        for (Method m : methods = compClass.getMethods()) {
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != 1) continue;
            method = m;
            break;
        }
        if (method == null) {
            throw new BuildException(String.format("Class %s does not have field \"%s\" or method \"%s\"", compClass.getName(), attr, methodName));
        }
        this.setAttributeMethod(method, component, value);
    }

    private void setAttributeField(Field field, Object component, String value) throws BuildException {
        block22: {
            Class<?> type = field.getType();
            try {
                AppComponentAttributeMapping<?> mapping = null;
                for (AppComponentAttributeMapping<?> m : this.attrMappings) {
                    if (!type.isAssignableFrom(m.getClass())) continue;
                    mapping = m;
                    break;
                }
                if (mapping != null) {
                    field.set(component, mapping.parseValue(value));
                    break block22;
                }
                if (type == Boolean.TYPE) {
                    field.setBoolean(component, Boolean.parseBoolean(value));
                    break block22;
                }
                if (type == Character.TYPE) {
                    if (value.length() != 1) {
                        throw new Exception("Invalid value for type char: \"" + value + "\"");
                    }
                    field.setChar(component, value.charAt(0));
                    break block22;
                }
                if (type == Byte.TYPE) {
                    field.setByte(component, Byte.parseByte(value));
                    break block22;
                }
                if (type == Short.TYPE) {
                    field.setShort(component, Short.parseShort(value));
                    break block22;
                }
                if (type == Integer.TYPE) {
                    field.setInt(component, Integer.parseInt(value));
                    break block22;
                }
                if (type == Float.TYPE) {
                    field.setFloat(component, Float.parseFloat(value));
                    break block22;
                }
                if (type == Double.TYPE) {
                    field.setDouble(component, Double.parseDouble(value));
                    break block22;
                }
                if (type == Long.TYPE || type == Long.class) {
                    Long longVal = null;
                    try {
                        longVal = Long.parseLong(value);
                    }
                    catch (NumberFormatException m) {
                        // empty catch block
                    }
                    try {
                        if (longVal == null) {
                            longVal = (Long)DateTimeUtils.parseDateTime(value, type);
                        }
                    }
                    catch (ParseException m) {
                        // empty catch block
                    }
                    if (longVal == null) {
                        throw new ParseException("Value is not a long or a date/time: " + value);
                    }
                    field.set(component, longVal);
                    break block22;
                }
                if (type == Date.class || type == Instant.class || type == Calendar.class || type == DateTime.class || type == LocalDate.class || type == LocalTime.class || type == LocalDateTime.class) {
                    Object dateTime = DateTimeUtils.parseDateTime(value, type);
                    field.set(component, dateTime);
                } else {
                    Constructor<?> cstr = type.getConstructor(String.class);
                    Object objVal = cstr.newInstance(value);
                    field.set(component, objVal);
                }
            }
            catch (InvocationTargetException ex) {
                Throwable targetEx = ex.getTargetException();
                throw new BuildException("String constructor of class " + type.getName() + " throws exception: " + targetEx.getMessage(), targetEx);
            }
            catch (Exception ex) {
                throw new BuildException(String.format("Can't set value \"%s\" to field \"%s\" with class %s", value, field.getName(), type.getName()) + ": " + ex.getMessage(), ex);
            }
        }
    }

    private void setAttributeMethod(Method method, Object component, String value) throws BuildException {
        block23: {
            Class<?> type = method.getParameterTypes()[0];
            try {
                Object objVal;
                AppComponentAttributeMapping<?> mapping = null;
                for (AppComponentAttributeMapping<?> m : this.attrMappings) {
                    if (!type.isAssignableFrom(m.getClass())) continue;
                    mapping = m;
                    break;
                }
                if (mapping != null) {
                    method.invoke(component, mapping.parseValue(value));
                    break block23;
                }
                if (type == Boolean.TYPE) {
                    method.invoke(component, Boolean.parseBoolean(value));
                    break block23;
                }
                if (type == Character.TYPE) {
                    if (value.length() != 1) {
                        throw new Exception("Invalid value type char: \"" + value + "\"");
                    }
                    method.invoke(component, Character.valueOf(value.charAt(0)));
                    break block23;
                }
                if (type == Byte.TYPE) {
                    method.invoke(component, Byte.parseByte(value));
                    break block23;
                }
                if (type == Short.TYPE) {
                    method.invoke(component, Short.parseShort(value));
                    break block23;
                }
                if (type == Integer.TYPE) {
                    method.invoke(component, Integer.parseInt(value));
                    break block23;
                }
                if (type == Float.TYPE) {
                    method.invoke(component, Float.valueOf(Float.parseFloat(value)));
                    break block23;
                }
                if (type == Double.TYPE) {
                    method.invoke(component, Double.parseDouble(value));
                    break block23;
                }
                if (type == Long.TYPE || type == Long.class) {
                    Long longVal = null;
                    try {
                        longVal = Long.parseLong(value);
                    }
                    catch (NumberFormatException m) {
                        // empty catch block
                    }
                    try {
                        if (longVal == null) {
                            longVal = (Long)DateTimeUtils.parseDateTime(value, type);
                        }
                    }
                    catch (ParseException m) {
                        // empty catch block
                    }
                    if (longVal == null) {
                        throw new ParseException("Value is not a long or a date/time: " + value);
                    }
                    method.invoke(component, longVal);
                    break block23;
                }
                if (type == Date.class || type == Instant.class || type == Calendar.class || type == DateTime.class || type == LocalDate.class || type == LocalTime.class || type == LocalDateTime.class) {
                    Object dateTime = DateTimeUtils.parseDateTime(value, type);
                    method.invoke(component, dateTime);
                    break block23;
                }
                Constructor<?> cstr = type.getConstructor(String.class);
                try {
                    objVal = cstr.newInstance(value);
                }
                catch (InvocationTargetException ex) {
                    Throwable targetEx = ex.getTargetException();
                    throw new Exception("String constructor of class " + type.getName() + " throws exception: " + targetEx.getMessage(), targetEx);
                }
                method.invoke(component, objVal);
            }
            catch (InvocationTargetException ex) {
                Throwable targetEx = ex.getTargetException();
                throw new BuildException("Method " + method.getName() + " of class " + component.getClass().getName() + " throws exception: " + targetEx.getMessage(), targetEx);
            }
            catch (Exception ex) {
                throw new BuildException(String.format("Can't set value \"%s\" with method %s of class %s", value, method.getName(), component.getClass().getName()) + ": " + ex.getMessage(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComponent(Object component) {
        Object object = lock;
        synchronized (object) {
            this.components.add(component);
        }
    }

    public boolean hasComponent(Class<?> clazz) {
        return this.findComponent(clazz) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T findComponent(Class<T> clazz) {
        Object object = lock;
        synchronized (object) {
            for (Object comp : this.components) {
                Class<?> compClass = comp.getClass();
                if (!clazz.isAssignableFrom(compClass)) continue;
                return clazz.cast(comp);
            }
            return null;
        }
    }

    public <T> T getComponent(Class<T> clazz) throws RuntimeException {
        return this.getComponent(clazz, null);
    }

    public <T> T getComponent(Class<T> clazz, T defaultVal) {
        Object object = lock;
        synchronized (object) {
            T comp = this.findComponent(clazz);
            if (comp != null) {
                return comp;
            }
            try {
                comp = this.getDefaultComponent(clazz);
                this.components.add(comp);
                return comp;
            }
            catch (BuildException ex) {
                if (defaultVal != null) {
                    this.components.add(defaultVal);
                    return defaultVal;
                }
                throw new RuntimeException("Can't create default component of class " + clazz.getName() + ": " + ex.getMessage(), ex);
            }
        }
    }

    private <T> T getDefaultComponent(Class<T> clazz) throws BuildException {
        Object result;
        boolean isStatic;
        Method method;
        boolean isAbstract = (clazz.getModifiers() & 0x400) != 0;
        Constructor<T> cstr = null;
        if (!isAbstract) {
            try {
                cstr = clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (cstr != null) {
            try {
                return cstr.newInstance(new Object[0]);
            }
            catch (InvocationTargetException ex) {
                Throwable targetEx = ex.getTargetException();
                throw new BuildException("Default constructor of class " + clazz.getName() + " throws exception: " + targetEx.getMessage(), targetEx);
            }
            catch (Exception ex) {
                throw new BuildException("Can't instantiate class " + clazz.getName() + " with default constructor: " + ex.getMessage(), ex);
            }
        }
        try {
            method = clazz.getMethod("getInstance", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new BuildException("Class " + clazz.getName() + " cannot be instantiated and does not have static method getInstance(): " + ex.getMessage(), ex);
        }
        boolean bl = isStatic = (method.getModifiers() & 8) != 0;
        if (!isStatic) {
            throw new BuildException("Class " + clazz.getName() + " cannot be instantiated and does not have static method getInstance()");
        }
        try {
            result = method.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            throw new BuildException("Method getInstance() of class " + clazz.getName() + " throws exception: " + targetEx.getMessage(), targetEx);
        }
        catch (Exception ex) {
            throw new BuildException("Can't invoke method getInstance() of class " + clazz.getName() + ": " + ex.getMessage(), ex);
        }
        if (result == null) {
            throw new BuildException("Method getInstance() of class " + clazz.getName() + " returns null");
        }
        try {
            return clazz.cast(result);
        }
        catch (ClassCastException ex) {
            throw new BuildException("Class " + result.getClass().getName() + " cannot be cast to " + clazz.getName());
        }
    }
}

