/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.woolplatform.utils.json.JsonMapper;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataFormatter {
    private static final String INDENT = "    ";
    private ObjectMapper mapper = new ObjectMapper();

    public String format(Object value, boolean human) {
        return this.valueToString(value, human, false, 0);
    }

    public String format(Object value, boolean human, boolean json) {
        return this.valueToString(value, human, json, 0);
    }

    private String valueToString(Object value, boolean human, boolean json, int indent) {
        boolean isPrimitive;
        if (value == null) {
            return "null";
        }
        boolean bl = isPrimitive = value instanceof String || value instanceof Number || value instanceof Boolean;
        if (isPrimitive) {
            if (json) {
                return JsonMapper.generate(value);
            }
            return value.toString();
        }
        if (value instanceof List) {
            return this.listToString((List)value, human, json, indent);
        }
        if (value instanceof Map) {
            return this.mapToString((Map)value, human, json, indent);
        }
        if (json) {
            try {
                Map map = (Map)this.mapper.convertValue(value, Map.class);
                return this.valueToString(map, human, json, indent);
            }
            catch (IllegalArgumentException ex) {
                return JsonMapper.generate(value);
            }
        }
        return value.toString();
    }

    private String mapToString(Map<?, ?> map, boolean human, boolean json, int indent) {
        Set<?> keys = map.keySet();
        if (keys.isEmpty()) {
            return "{}";
        }
        StringBuffer buffer = new StringBuffer();
        String newline = System.getProperty("line.separator");
        buffer.append("{");
        if (human && keys.size() > 1) {
            buffer.append(newline);
            this.indent(buffer, indent + 1);
        } else if (human) {
            buffer.append(" ");
        }
        boolean first = true;
        for (Object key : keys) {
            if (!first) {
                buffer.append(",");
                if (human) {
                    buffer.append(newline);
                    this.indent(buffer, indent + 1);
                }
            }
            first = false;
            buffer.append(this.valueToString(key, false, json, 0) + ":");
            if (human) {
                buffer.append(" ");
            }
            Object val = map.get(key);
            String valStr = this.valueToString(val, human, json, indent + 1);
            buffer.append(valStr);
        }
        if (human && keys.size() > 1) {
            buffer.append(newline);
            this.indent(buffer, indent);
        } else if (human) {
            buffer.append(" ");
        }
        buffer.append("}");
        return buffer.toString();
    }

    private String listToString(List<?> list, boolean human, boolean json, int indent) {
        if (list.isEmpty()) {
            return "[]";
        }
        StringBuffer buffer = new StringBuffer();
        String newline = System.getProperty("line.separator");
        buffer.append("[");
        if (human && list.size() > 1) {
            buffer.append(newline);
            this.indent(buffer, indent + 1);
        } else if (human) {
            buffer.append(" ");
        }
        boolean first = true;
        for (Object item : list) {
            if (!first) {
                buffer.append(",");
                if (human) {
                    buffer.append(newline);
                    this.indent(buffer, indent + 1);
                }
            }
            first = false;
            String itemStr = this.valueToString(item, human, json, indent + 1);
            buffer.append(itemStr);
        }
        if (human && list.size() > 1) {
            buffer.append(newline);
            this.indent(buffer, indent);
        } else if (human) {
            buffer.append(" ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    private void indent(StringBuffer buffer, int indent) {
        for (int i = 0; i < indent; ++i) {
            buffer.append(INDENT);
        }
    }
}

