/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.LinkedHashMap;
import java.util.Map;

public class ReflectionUtils {
    public static Class<?> getGenericListElementType(Field field) {
        Type genericType = field.getGenericType();
        if (genericType instanceof Class) {
            return Object.class;
        }
        if (!(genericType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("List field type is not a Class or ParameterizedType: " + genericType.getClass().getName());
        }
        Type prmType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
        return ReflectionUtils.getGenericTypeClass(prmType);
    }

    public static Class<?> getGenericMapValueType(Field field) {
        Type genericType = field.getGenericType();
        if (genericType instanceof Class) {
            return Object.class;
        }
        if (!(genericType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Map field type is not a Class or ParameterizedType: " + genericType.getClass().getName());
        }
        Type prmType = ((ParameterizedType)genericType).getActualTypeArguments()[1];
        return ReflectionUtils.getGenericTypeClass(prmType);
    }

    public static Class<?> getGenericTypeClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType prmType = (ParameterizedType)type;
            return (Class)prmType.getRawType();
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type upperType = wildcardType.getUpperBounds()[0];
            return ReflectionUtils.getGenericTypeClass(upperType);
        }
        throw new IllegalArgumentException("Bounded type parameter is not a Class, ParameterizedType or WildcardType: " + type.getClass().getName());
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) throws InstantiationException, InvocationTargetException {
        Object result;
        Constructor<?> constr = ReflectionUtils.findConstructor(clazz, params);
        try {
            result = constr.newInstance(params);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return clazz.cast(result);
    }

    public static <T> T invokeMethod(Object object, Class<T> resultClass, String methodName, Object ... params) throws NoSuchMethodException, InvocationTargetException {
        Object result;
        Method method = ReflectionUtils.findMethod(object.getClass(), false, resultClass, methodName, params);
        try {
            result = method.invoke(object, params);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        if (resultClass == null || result == null) {
            return null;
        }
        return resultClass.cast(result);
    }

    public static <T> T invokeStaticMethod(Class<?> clazz, Class<T> resultClass, String methodName, Object ... params) throws NoSuchMethodException, InvocationTargetException {
        Object result;
        Method method = ReflectionUtils.findMethod(clazz, true, resultClass, methodName, params);
        try {
            result = method.invoke(null, params);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        if (resultClass == null || result == null) {
            return null;
        }
        return resultClass.cast(result);
    }

    public static <T> T getField(Object object, Class<T> resultClass, String fieldName) throws NoSuchFieldException {
        Object result;
        Field field = ReflectionUtils.findField(object.getClass(), false, resultClass, fieldName);
        try {
            result = field.get(object);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        if (result == null) {
            return null;
        }
        return resultClass.cast(result);
    }

    public static <T> T getStaticField(Class<?> clazz, Class<T> resultClass, String fieldName) throws NoSuchFieldException {
        Object result;
        Field field = ReflectionUtils.findField(clazz, true, resultClass, fieldName);
        try {
            result = field.get(null);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        if (result == null) {
            return null;
        }
        return resultClass.cast(result);
    }

    private static Constructor<?> findConstructor(Class<?> clazz, Object ... params) throws InstantiationException {
        Constructor<?>[] constrs;
        int modifiers = clazz.getModifiers();
        if ((modifiers & 1) == 0) {
            throw new InstantiationException("Class " + clazz.getName() + " is not public");
        }
        if ((modifiers & 0x400) != 0) {
            throw new InstantiationException("Class " + clazz.getName() + " is abstract");
        }
        for (Constructor<?> constr : constrs = clazz.getConstructors()) {
            Class<?>[] paramTypes;
            modifiers = constr.getModifiers();
            if ((modifiers & 1) == 0 || (modifiers & 0x400) != 0 || (paramTypes = constr.getParameterTypes()).length != params.length) continue;
            boolean paramsMatch = true;
            for (int i = 0; paramsMatch && i < params.length; ++i) {
                Object param = params[i];
                Class<?> paramType = paramTypes[i];
                if (param == null && paramType.isPrimitive()) {
                    paramsMatch = false;
                    continue;
                }
                if (param == null || paramType.isInstance(param)) continue;
                paramsMatch = false;
            }
            if (!paramsMatch) continue;
            return constr;
        }
        StringBuilder paramString = new StringBuilder();
        for (Object param : params) {
            if (paramString.length() > 0) {
                paramString.append(", ");
            }
            if (param == null) {
                paramString.append("null");
                continue;
            }
            paramString.append(param.getClass().getName());
        }
        throw new InstantiationException("Class " + clazz.getName() + " does not have public constructor for parameters (" + paramString + ")");
    }

    private static Method findMethod(Class<?> clazz, boolean isStatic, Class<?> resultClass, String methodName, Object ... params) throws NoSuchMethodException {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            Class<?> returnObjClass;
            Class<?> resultObjClass;
            Class<?>[] paramTypes;
            boolean currentIsStatic;
            int modifiers = method.getModifiers();
            if (!method.getName().equals(methodName) || (modifiers & 1) == 0) continue;
            boolean bl = currentIsStatic = (modifiers & 8) != 0;
            if (isStatic != currentIsStatic || (modifiers & 0x400) != 0 || (paramTypes = method.getParameterTypes()).length != params.length) continue;
            boolean paramsMatch = true;
            for (int i = 0; paramsMatch && i < params.length; ++i) {
                Object param = params[i];
                Class<?> paramType = paramTypes[i];
                if (param == null && paramType.isPrimitive()) {
                    paramsMatch = false;
                    continue;
                }
                if (param == null || paramType.isInstance(param)) continue;
                paramsMatch = false;
            }
            if (!paramsMatch || resultClass != null && (method.getReturnType() == null || !(resultObjClass = ReflectionUtils.primitiveTypeToObjectClass(resultClass)).isAssignableFrom(returnObjClass = ReflectionUtils.primitiveTypeToObjectClass(method.getReturnType())))) continue;
            return method;
        }
        StringBuilder paramString = new StringBuilder();
        for (Object param : params) {
            if (paramString.length() > 0) {
                paramString.append(", ");
            }
            if (param == null) {
                paramString.append("null");
                continue;
            }
            paramString.append(param.getClass().getName());
        }
        String error = "Class " + clazz.getName() + " does not have public, " + (isStatic ? "static" : "non-static") + ", non-abstract method " + methodName + " for parameters (" + paramString + ")";
        if (resultClass != null) {
            error = error + " with result assignable to " + resultClass.getName();
        }
        throw new NoSuchMethodException(error);
    }

    private static Field findField(Class<?> clazz, boolean isStatic, Class<?> resultClass, String fieldName) throws NoSuchFieldException {
        Field[] fields;
        for (Field field : fields = clazz.getFields()) {
            Class<?> fieldObjClass;
            Class<?> resultObjClass;
            boolean currentIsStatic;
            int modifiers = field.getModifiers();
            if (!field.getName().equals(fieldName) || (modifiers & 1) == 0) continue;
            boolean bl = currentIsStatic = (modifiers & 8) != 0;
            if (isStatic != currentIsStatic || resultClass != null && !(resultObjClass = ReflectionUtils.primitiveTypeToObjectClass(resultClass)).isAssignableFrom(fieldObjClass = ReflectionUtils.primitiveTypeToObjectClass(field.getType()))) continue;
            return field;
        }
        String error = "Class " + clazz.getName() + " does not have public, " + (isStatic ? "static" : "non-static") + " field " + fieldName;
        if (resultClass != null) {
            error = error + " assignable to type " + resultClass.getName();
        }
        throw new NoSuchFieldException(error);
    }

    public static Class<?> primitiveTypeToObjectClass(Class<?> clazz) {
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        return clazz;
    }

    public static Map<String, Integer> getConstantIntMap(Class<?> clazz, String prefix) {
        return ReflectionUtils.getConstantMap(clazz, prefix, Integer.class);
    }

    public static Map<String, String> getConstantStringMap(Class<?> clazz, String prefix) {
        return ReflectionUtils.getConstantMap(clazz, prefix, String.class);
    }

    public static <T> Map<String, T> getConstantMap(Class<?> constantClass, String prefix, Class<T> valueClass) {
        Field[] fields;
        LinkedHashMap<String, T> map = new LinkedHashMap<String, T>();
        for (Field field : fields = constantClass.getFields()) {
            Object fieldObjValue;
            Class<?> fieldObjClass;
            int modifiers = field.getModifiers();
            if ((modifiers & 1) == 0 || (modifiers & 8) == 0 || (modifiers & 0x10) == 0 || !field.getName().startsWith(prefix) || !valueClass.isAssignableFrom(fieldObjClass = ReflectionUtils.primitiveTypeToObjectClass(field.getType()))) continue;
            try {
                fieldObjValue = field.get(null);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Can't read field: " + field.getName() + ": " + ex.getMessage(), ex);
            }
            T fieldValue = valueClass.cast(fieldObjValue);
            map.put(field.getName(), fieldValue);
        }
        return map;
    }

    public static String findConstantInt(Class<?> clazz, String prefix, int value) {
        Map<String, Integer> constants = ReflectionUtils.getConstantIntMap(clazz, prefix);
        for (String key : constants.keySet()) {
            if (constants.get(key) != value) continue;
            return key;
        }
        return Integer.toString(value);
    }
}

