/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils;

import eu.woolplatform.utils.exception.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringEscape {
    public static String resolveEscapes(String s) throws ParseException {
        return StringEscape.resolveEscapes(s, new char[0]);
    }

    public static String resolveEscapes(String s, char[] illegals) throws ParseException {
        StringBuilder result = new StringBuilder();
        String patStr = "\\\\";
        for (char c : illegals) {
            patStr = patStr + "|" + c;
        }
        Pattern pattern = Pattern.compile(patStr);
        Matcher m = pattern.matcher(s);
        int start = 0;
        while (start < s.length() && m.find(start)) {
            int index = m.start();
            char c = s.charAt(index);
            if (c != '\\' || index == s.length() - 1) {
                throw new ParseException("Invalid escaped string: \"" + s + "\"");
            }
            c = s.charAt(index + 1);
            result.append(s, start, index);
            switch (c) {
                case 'n': {
                    c = '\n';
                    break;
                }
                case 'r': {
                    c = '\r';
                    break;
                }
                case 't': {
                    c = '\t';
                }
            }
            result.append(c);
            start = index + 2;
        }
        if (start < s.length()) {
            result.append(s.substring(start));
        }
        return result.toString();
    }

    public static String escape(String s) {
        return StringEscape.escape(s, new char[0]);
    }

    public static String escape(String s, char[] illegals) {
        String escaped = s.replaceAll("\\\\", "\\\\\\\\");
        escaped = escaped.replaceAll("\n", "\\\\n");
        escaped = escaped.replaceAll("\r", "\\\\r");
        escaped = escaped.replaceAll("\t", "\\\\t");
        for (char c : illegals) {
            escaped = escaped.replaceAll(Character.toString(c), "\\\\" + c);
        }
        return escaped;
    }
}

